/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.Reactor;
import com.github.danielflower.mavenplugins.release.ReleasableModule;
import com.github.danielflower.mavenplugins.release.ValidationException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class PomUpdater {
    private final Log log;
    private final Reactor reactor;

    public PomUpdater(Log log, Reactor reactor) {
        this.log = log;
        this.reactor = reactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> updateVersion() throws IOException, ValidationException {
        ArrayList<File> changedPoms = new ArrayList<File>();
        for (ReleasableModule module : this.reactor.getModulesInBuildOrder()) {
            MavenProject project = module.getProject();
            this.log.info((CharSequence)("Going to release " + module.getArtifactId() + " " + module.getNewVersion()));
            Model originalModel = project.getOriginalModel();
            this.alterModel(project, module.getNewVersion());
            File pom = project.getFile();
            changedPoms.add(pom);
            FileWriter fileWriter = new FileWriter(pom);
            try {
                MavenXpp3Writer pomWriter = new MavenXpp3Writer();
                pomWriter.write((Writer)fileWriter, originalModel);
            }
            finally {
                ((Writer)fileWriter).close();
            }
        }
        return changedPoms;
    }

    private void alterModel(MavenProject project, String newVersion) throws ValidationException {
        Model originalModel = project.getOriginalModel();
        originalModel.setVersion(newVersion);
        MavenProject parent = project.getParent();
        if (parent != null && this.isSnapshot(parent.getVersion())) {
            String searchingFrom = "the parent reference in " + project.getFile().getAbsolutePath();
            ReleasableModule parentBeingReleased = this.reactor.find(searchingFrom, parent.getGroupId(), parent.getArtifactId());
            originalModel.getParent().setVersion(parentBeingReleased.getNewVersion());
        }
        for (Dependency dependency : originalModel.getDependencies()) {
            if (!this.isSnapshot(dependency.getVersion())) continue;
            String searchingFrom = "a dependency in " + project.getFile().getAbsolutePath();
            ReleasableModule dependencyBeingReleased = this.reactor.find(searchingFrom, dependency.getGroupId(), dependency.getArtifactId());
            dependency.setVersion(dependencyBeingReleased.getNewVersion());
        }
    }

    private boolean isSnapshot(String version) {
        return version != null && version.endsWith("-SNAPSHOT");
    }
}

