/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.extras.spring3.i18n;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.i18n.AbstractMessageResolver;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.web.servlet.support.RequestContextUtils;

public class SpringMessageResolver
extends AbstractMessageResolver {
    private static Logger logger = LoggerFactory.getLogger(SpringMessageResolver.class);
    private MessageSource messageSource;

    public SpringMessageResolver() {
    }

    public SpringMessageResolver(HttpServletRequest request) {
        super(request);
        this.messageSource = RequestContextUtils.getWebApplicationContext((ServletRequest)request);
    }

    public String getResource(String messageKey, String defaultValue, Object ... objects) {
        String message;
        block4: {
            Locale locale = RequestContextUtils.getLocale((HttpServletRequest)this.request);
            message = null;
            if (messageKey == null || StringUtils.isBlank((String)messageKey) && StringUtils.isNotBlank((String)defaultValue)) {
                message = StringUtils.capitalize((String)defaultValue);
            } else {
                try {
                    message = this.messageSource.getMessage(messageKey, null, locale);
                }
                catch (NoSuchMessageException e) {
                    logger.warn("No message found with the key {} and locale {}.", (Object)messageKey, (Object)locale);
                    if (!StringUtils.isBlank((String)message)) break block4;
                    message = "???" + messageKey + "???";
                }
            }
        }
        return message;
    }
}

