/*
 * [The "BSD licence"]
 * Copyright (c) 2012 Dandelion
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Dandelion nor the names of its contributors 
 * may be used to endorse or promote products derived from this software 
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.github.dandelion.datatables.core.html;

import com.github.dandelion.core.html.AbstractHtmlTag;

/**
 * Abstract superclass for all HTML tags with embedded content.
 * 
 * @author Gautier Dhordain
 */
public abstract class HtmlTagWithContent extends AbstractHtmlTag {

   /**
    * Content of the tag.
    */
   protected StringBuilder content = new StringBuilder();

   /**
    * Render the tag in HTML code.
    * 
    * @return the HTML code corresponding to the tag.
    */
   @Override
   public StringBuilder toHtml() {
      StringBuilder html = new StringBuilder();
      html.append(getHtmlOpeningTag());
      html.append(this.content);
      html.append(getHtmlClosingTag());
      return html;
   }

   public StringBuilder getContent() {
      return content;
   }

   public void setContent(StringBuilder content) {
      this.content = content;
   }

   public void addContent(StringBuilder contentToAdd) {
      this.content.append(contentToAdd);
   }

   public void addContent(String contentToAdd) {
      this.content.append(contentToAdd);
   }
}