/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;

public class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static InputStream getFileFromWebapp(String pathToFile) throws FileNotFoundException {
        File file = new File(pathToFile);
        FileInputStream inputStream = new FileInputStream(file);
        return inputStream;
    }

    public static InputStream getFileFromClasspath(String pathToFile) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(pathToFile);
    }

    public static String getFileContentFromClasspath(String pathToFile) throws IOException {
        return FileUtils.toString(FileUtils.getFileFromClasspath(pathToFile));
    }

    public static String getFileContentFromWebapp(String pathToFile) throws IOException {
        return FileUtils.toString(FileUtils.getFileFromWebapp(pathToFile));
    }

    public static String toString(InputStream input) throws IOException {
        StringWriter sw = new StringWriter();
        InputStreamReader in = new InputStreamReader(input);
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            sw.write(buffer, 0, n);
        }
        return sw.toString();
    }
}

