/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.processor.feature;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.exception.ConfigurationProcessingException;
import com.github.dandelion.datatables.core.extension.feature.PaginationType;
import com.github.dandelion.datatables.core.extension.feature.PaginationTypeBootstrapFeature;
import com.github.dandelion.datatables.core.extension.feature.PaginationTypeBootstrapFourButtonFeature;
import com.github.dandelion.datatables.core.extension.feature.PaginationTypeBootstrapFullNumbersFeature;
import com.github.dandelion.datatables.core.extension.feature.PaginationTypeFourButtonFeature;
import com.github.dandelion.datatables.core.extension.feature.PaginationTypeInputFeature;
import com.github.dandelion.datatables.core.extension.feature.PaginationTypeListboxFeature;
import com.github.dandelion.datatables.core.extension.feature.PaginationTypeScrollingFeature;
import com.github.dandelion.datatables.core.processor.AbstractConfigurationProcessor;

public class FeaturePaginationTypeProcessor
extends AbstractConfigurationProcessor {
    @Override
    public void doProcess() {
        PaginationType type = null;
        if (StringUtils.isNotBlank((String)this.stringifiedValue)) {
            try {
                type = PaginationType.valueOf(this.stringifiedValue.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationProcessingException(this.stringifiedValue + " is not a valid value among " + PaginationType.values(), e);
            }
            switch (type) {
                case INPUT: {
                    this.tableConfiguration.registerExtension(new PaginationTypeInputFeature());
                    break;
                }
                case LISTBOX: {
                    this.tableConfiguration.registerExtension(new PaginationTypeListboxFeature());
                    break;
                }
                case SCROLLING: {
                    this.tableConfiguration.registerExtension(new PaginationTypeScrollingFeature());
                    break;
                }
                case FOUR_BUTTON: {
                    this.tableConfiguration.registerExtension(new PaginationTypeFourButtonFeature());
                    break;
                }
                case BOOTSTRAP: {
                    this.tableConfiguration.registerExtension(new PaginationTypeBootstrapFeature());
                    break;
                }
                case BOOTSTRAP_FOUR_BUTTON: {
                    this.tableConfiguration.registerExtension(new PaginationTypeBootstrapFourButtonFeature());
                    break;
                }
                case BOOTSTRAP_FULL_NUMBERS: {
                    this.tableConfiguration.registerExtension(new PaginationTypeBootstrapFullNumbersFeature());
                    break;
                }
            }
        }
        this.updateEntry((Object)type);
    }
}

