/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.i18n;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class DefaultMessages {
    private static final String BUNDLE_NAME = "datatables";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("datatables");

    private DefaultMessages() {
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getString(String key, Object[] parameters) {
        String baseMsg;
        try {
            baseMsg = RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
        return MessageFormat.format(baseMsg, parameters);
    }

    public static String getString(String key, Object parameter) {
        return DefaultMessages.getString(key, new Object[]{parameter});
    }
}

