/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.html;

import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.configuration.TableConfiguration;
import com.github.dandelion.datatables.core.html.HtmlCaption;
import com.github.dandelion.datatables.core.html.HtmlRow;
import com.github.dandelion.datatables.core.html.HtmlTag;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HtmlTable
extends HtmlTag {
    private String originalId;
    private HtmlCaption caption;
    private List<HtmlRow> head = new LinkedList<HtmlRow>();
    private List<HtmlRow> body = new LinkedList<HtmlRow>();
    private List<HtmlRow> foot = new LinkedList<HtmlRow>();
    private TableConfiguration tableConfiguration;

    public HtmlTable(String id, HttpServletRequest request, HttpServletResponse response) {
        this(id, request, response, null, null);
    }

    public HtmlTable(String id, HttpServletRequest request, HttpServletResponse response, String groupName) {
        this(id, request, response, groupName, null);
    }

    public HtmlTable(String id, HttpServletRequest request, HttpServletResponse response, String groupName, Map<String, String> dynamicAttributes) {
        this.tag = "table";
        this.originalId = id;
        this.id = this.processId(id);
        this.dynamicAttributes = dynamicAttributes;
        this.tableConfiguration = TableConfiguration.getInstance(id, request, groupName);
    }

    @Override
    public StringBuilder toHtml() {
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)this.getHtmlOpeningTag());
        html.append((CharSequence)this.getHtmlHeader());
        html.append((CharSequence)this.getHtmlBody());
        html.append((CharSequence)this.getHtmlFooter());
        html.append((CharSequence)this.getHtmlClosingTag());
        return html;
    }

    private StringBuilder getHtmlHeader() {
        StringBuilder html = new StringBuilder();
        if (this.caption != null) {
            html.append((CharSequence)this.caption.toHtml());
        }
        html.append("<thead>");
        for (HtmlRow row : this.head) {
            html.append((CharSequence)row.toHtml());
        }
        html.append("</thead>");
        return html;
    }

    private StringBuilder getHtmlBody() {
        StringBuilder html = new StringBuilder();
        html.append("<tbody>");
        for (HtmlRow row : this.body) {
            html.append((CharSequence)row.toHtml());
        }
        html.append("</tbody>");
        return html;
    }

    private StringBuilder getHtmlFooter() {
        StringBuilder html = new StringBuilder();
        if (!this.foot.isEmpty()) {
            html.append("<tfoot>");
            for (HtmlRow row : this.foot) {
                html.append((CharSequence)row.toHtml());
            }
            html.append("</tfoot>");
        }
        return html;
    }

    @Override
    protected StringBuilder getHtmlAttributes() {
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)HtmlTable.writeAttribute("id", this.id));
        html.append((CharSequence)HtmlTable.writeAttribute("class", TableConfig.CSS_CLASS.valueFrom(this.tableConfiguration)));
        html.append((CharSequence)HtmlTable.writeAttribute("style", TableConfig.CSS_STYLE.valueFrom(this.tableConfiguration)));
        return html;
    }

    public HtmlCaption getCaption() {
        return this.caption;
    }

    public void setCaption(HtmlCaption caption) {
        this.caption = caption;
    }

    public List<HtmlRow> getHeadRows() {
        return this.head;
    }

    public List<HtmlRow> getBodyRows() {
        return this.body;
    }

    public HtmlRow addHeaderRow() {
        HtmlRow row = new HtmlRow();
        this.head.add(row);
        return row;
    }

    public HtmlRow addRow() {
        HtmlRow row = new HtmlRow();
        this.body.add(row);
        return row;
    }

    public HtmlRow addFooterRow() {
        HtmlRow row = new HtmlRow();
        this.foot.add(row);
        return row;
    }

    public HtmlRow addRow(String rowId) {
        HtmlRow row = new HtmlRow(rowId);
        this.body.add(row);
        return row;
    }

    public HtmlTable addRows(HtmlRow ... rows) {
        for (HtmlRow row : rows) {
            this.body.add(row);
        }
        return this;
    }

    public HtmlRow getLastFooterRow() {
        return (HtmlRow)((LinkedList)this.foot).getLast();
    }

    public HtmlRow getFirstHeaderRow() {
        return (HtmlRow)((LinkedList)this.head).getFirst();
    }

    public HtmlRow getLastHeaderRow() {
        return (HtmlRow)((LinkedList)this.head).getLast();
    }

    public HtmlRow getLastBodyRow() {
        return (HtmlRow)((LinkedList)this.body).getLast();
    }

    @Override
    public void addCssStyle(String cssStyle) {
        if (TableConfig.CSS_STYLE.valueFrom(this.tableConfiguration) == null) {
            TableConfig.CSS_STYLE.setIn(this.tableConfiguration, new StringBuilder());
        } else {
            TableConfig.CSS_STYLE.appendIn(this.tableConfiguration, ';');
        }
        TableConfig.CSS_STYLE.appendIn(this.tableConfiguration, cssStyle);
    }

    @Override
    public void addCssClass(String cssClass) {
        if (TableConfig.CSS_CLASS.valueFrom(this.tableConfiguration) == null) {
            TableConfig.CSS_CLASS.setIn(this.tableConfiguration, new StringBuilder());
        } else {
            TableConfig.CSS_CLASS.appendIn(this.tableConfiguration, ' ');
        }
        TableConfig.CSS_CLASS.appendIn(this.tableConfiguration, cssClass);
    }

    public TableConfiguration getTableConfiguration() {
        return this.tableConfiguration;
    }

    public void setTableConfiguration(TableConfiguration tableConfiguration) {
        this.tableConfiguration = tableConfiguration;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    private String processId(String id) {
        return id.replaceAll("[^A-Za-z0-9 ]", "");
    }
}

