/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.generator.configuration;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.asset.JavascriptSnippet;
import com.github.dandelion.datatables.core.configuration.ColumnConfig;
import com.github.dandelion.datatables.core.configuration.ColumnConfiguration;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.extension.feature.FilterPlaceholder;
import com.github.dandelion.datatables.core.extension.feature.FilterType;
import com.github.dandelion.datatables.core.generator.configuration.AbstractConfigurationGenerator;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFilteringGenerator
extends AbstractConfigurationGenerator {
    private static Logger logger = LoggerFactory.getLogger(ColumnFilteringGenerator.class);

    @Override
    public Map<String, Object> generateConfig(HtmlTable table) {
        Integer filterColumnDelay;
        String filterTrigger;
        logger.debug("Generating Column Filtering configuration...");
        HashMap<String, Object> filteringConf = new HashMap<String, Object>();
        FilterPlaceholder filterPlaceholder = TableConfig.FEATURE_FILTER_PLACEHOLDER.valueFrom(table);
        if (filterPlaceholder != null) {
            filteringConf.put("sPlaceHolder", filterPlaceholder.getName());
        }
        if (StringUtils.isNotBlank((String)(filterTrigger = TableConfig.FEATURE_FILTER_TRIGGER.valueFrom(table)))) {
            filteringConf.put("sFilteringTrigger", filterTrigger);
        }
        if ((filterColumnDelay = TableConfig.FEATURE_FILTER_DELAY.valueFrom(table)) != null) {
            filteringConf.put("iFilteringDelay", filterColumnDelay);
        }
        HashMap<String, Object> tmp = null;
        ArrayList aoColumnsContent = new ArrayList();
        for (HtmlColumn column : table.getLastHeaderRow().getColumns()) {
            Integer filterMinLength;
            String filterValues;
            String selector;
            Set<String> enabledDisplayTypes = column.getEnabledDisplayTypes();
            if (!CollectionUtils.containsAny(enabledDisplayTypes, "all", "html")) continue;
            tmp = new HashMap<String, Object>();
            ColumnConfiguration columnConfiguration = column.getColumnConfiguration();
            Boolean filterable = ColumnConfig.FILTERABLE.valueFrom(columnConfiguration);
            FilterType filterType = ColumnConfig.FILTERTYPE.valueFrom(columnConfiguration);
            if (filterable != null && filterable.booleanValue() && filterType != null) {
                switch (filterType) {
                    case INPUT: {
                        tmp.put("type", "text");
                        break;
                    }
                    case NUMBER: {
                        tmp.put("type", "number");
                        break;
                    }
                    case SELECT: {
                        tmp.put("type", "select");
                        break;
                    }
                    case NUMBER_RANGE: {
                        tmp.put("type", "number-range");
                        break;
                    }
                    case DATE_RANGE: {
                        tmp.put("type", "date-range");
                        String dateFormat = ColumnConfig.FILTERDATEFORMAT.valueFrom(columnConfiguration);
                        if (!StringUtils.isNotBlank((String)dateFormat)) break;
                        tmp.put("sDateFormat", dateFormat);
                    }
                }
            } else {
                tmp.put("type", "null");
            }
            String name = ColumnConfig.NAME.valueFrom(columnConfiguration);
            if (StringUtils.isNotBlank((String)name)) {
                tmp.put("sName", name);
            }
            if (StringUtils.isNotBlank((String)(selector = ColumnConfig.SELECTOR.valueFrom(columnConfiguration)))) {
                tmp.put("sSelector", selector);
            }
            if (StringUtils.isNotBlank((String)(filterValues = ColumnConfig.FILTERVALUES.valueFrom(columnConfiguration)))) {
                tmp.put("values", new JavascriptSnippet(filterValues));
            }
            if ((filterMinLength = ColumnConfig.FILTERMINLENGTH.valueFrom(columnConfiguration)) != null) {
                tmp.put("iFilterLength", filterMinLength);
            }
            aoColumnsContent.add(tmp);
            String filterCssClass = ColumnConfig.FILTERCSSCLASS.valueFrom(columnConfiguration);
            if (!StringUtils.isNotBlank((String)filterCssClass)) continue;
            tmp.put("sClass", filterCssClass);
        }
        filteringConf.put("aoColumns", aoColumnsContent);
        logger.debug("Column filtering configuration generated");
        return filteringConf;
    }
}

