/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.generator;

import com.github.dandelion.datatables.core.asset.JsResource;
import com.github.dandelion.datatables.core.exception.WebResourceGenerationException;
import com.github.dandelion.datatables.core.extension.ExtensionLoader;
import com.github.dandelion.datatables.core.generator.configuration.DatatablesGenerator;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.JsonIndentingWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceGenerator {
    private static Logger logger = LoggerFactory.getLogger(WebResourceGenerator.class);
    private HtmlTable table;
    private static DatatablesGenerator configGenerator;

    public WebResourceGenerator(HtmlTable table) {
        this.table = table;
    }

    public JsResource generateWebResources() {
        JsResource mainJsFile = new JsResource(this.table.getId(), this.table.getOriginalId());
        configGenerator = new DatatablesGenerator();
        Map<String, Object> mainConf = configGenerator.generateConfig(this.table);
        logger.debug("Loading extensions...");
        ExtensionLoader extensionLoader = new ExtensionLoader(this.table);
        extensionLoader.loadExtensions(mainJsFile, mainConf);
        logger.debug("Transforming configuration to JSON...");
        try {
            JsonIndentingWriter writer = new JsonIndentingWriter();
            JSONValue.writeJSONString(mainConf, (Writer)writer);
            mainJsFile.appendToDataTablesConf(((Object)writer).toString());
        }
        catch (IOException e) {
            throw new WebResourceGenerationException("Unable to generate the JSON configuration", e);
        }
        return mainJsFile;
    }
}

