/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.theme;

import com.github.dandelion.datatables.core.asset.Parameter;
import com.github.dandelion.datatables.core.callback.CallbackType;
import com.github.dandelion.datatables.core.configuration.DatatableBundles;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.html.HtmlTable;

public class Bootstrap3ResponsiveTheme
extends AbstractExtension {
    @Override
    public String getName() {
        return "bootstrap3-responsive";
    }

    @Override
    public void setup(HtmlTable table) {
        this.addBundle(DatatableBundles.DDL_DT_THEME_BOOTSTRAP3_RESPONSIVE);
        StringBuilder var = new StringBuilder();
        var.append("var responsiveHelper_").append(table.getId()).append(";\n");
        var.append("var breakpointDefinition = { tablet: 1024, phone : 480 };\n");
        this.appendToBeforeAll(var.toString());
        this.addParameter("bAutoWidth", false, Parameter.Mode.OVERRIDE);
        this.addCallback(CallbackType.PREDRAW, "if (!responsiveHelper_" + table.getId() + ") { responsiveHelper_" + table.getId() + " = new ResponsiveDatatablesHelper(oTable_" + table.getId() + ", breakpointDefinition); }");
        this.addCallback(CallbackType.ROW, "responsiveHelper_" + table.getId() + ".createExpandIcon(nRow);");
        this.addCallback(CallbackType.DRAW, "responsiveHelper_" + table.getId() + ".respond();");
    }
}

