/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.plugin;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.DatatableBundles;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONValue;

public class FixedHeaderPlugin
extends AbstractExtension {
    @Override
    public String getName() {
        return "FixedHeader";
    }

    @Override
    public void setup(HtmlTable table) {
        this.addBundle(DatatableBundles.DDL_DT_PLUGIN_FIXEDHEADER);
        Map<String, Object> specificConfObj = this.getSpecificCongiguration(table);
        String specificConfStr = JSONValue.toJSONString(specificConfObj);
        this.appendToBeforeEndDocumentReady("new FixedHeader(oTable_" + table.getId() + "," + specificConfStr + ");");
    }

    private Map<String, Object> getSpecificCongiguration(HtmlTable table) {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        String fixedPosition = TableConfig.PLUGIN_FIXEDPOSITION.valueFrom(table);
        Integer fixedOffset = TableConfig.PLUGIN_FIXEDOFFSETTOP.valueFrom(table);
        if (StringUtils.isNotBlank((String)fixedPosition)) {
            if (fixedPosition.toLowerCase().equals("bottom")) {
                conf.put("bottom", true);
            } else if (fixedPosition.toLowerCase().equals("right")) {
                conf.put("right", true);
            } else if (fixedPosition.toLowerCase().equals("left")) {
                conf.put("left", true);
            } else {
                conf.put("top", true);
            }
        } else {
            conf.put("top", true);
        }
        if (fixedOffset != null) {
            conf.put("offsetTop", fixedOffset);
        }
        return conf;
    }
}

