/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.asset.Asset;
import com.github.dandelion.core.asset.AssetMapper;
import com.github.dandelion.core.asset.AssetType;
import com.github.dandelion.core.asset.locator.spi.AssetLocator;
import com.github.dandelion.core.storage.AssetStorageUnit;
import com.github.dandelion.datatables.core.asset.ExtraJs;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ExtraJsFeature
extends AbstractExtension {
    @Override
    public String getName() {
        return "extraJs";
    }

    @Override
    public void setup(HtmlTable table) {
        AssetMapper assetMapper = new AssetMapper(table.getTableConfiguration().getRequest(), this.getContext());
        HttpServletRequest request = table.getTableConfiguration().getRequest();
        LinkedHashSet assetsToInject = null;
        for (ExtraJs extraJs : table.getTableConfiguration().getExtraJs()) {
            assetsToInject = new LinkedHashSet();
            for (String bundleName : extraJs.getBundles()) {
                assetsToInject.addAll(this.getContext().getBundleStorage().getBundleDag().getVertex(bundleName).getAssetStorageUnits());
            }
            LinkedHashSet<AssetStorageUnit> filteredAsus = new LinkedHashSet<AssetStorageUnit>();
            for (AssetStorageUnit asu : assetsToInject) {
                if (!asu.getType().equals((Object)AssetType.js)) continue;
                filteredAsus.add(asu);
            }
            Set processedAssets = assetMapper.mapToAssets(filteredAsus);
            Map locators = this.getContext().getAssetLocatorsMap();
            for (Asset asset : processedAssets) {
                AssetLocator locator = (AssetLocator)locators.get(asset.getConfigLocationKey());
                String content = locator.getContent(asset, request);
                if (!content.endsWith("\n")) {
                    content = content + "\n";
                }
                switch (extraJs.getInsert()) {
                    case BEFOREALL: {
                        this.appendToBeforeAll(content);
                        break;
                    }
                    case AFTERSTARTDOCUMENTREADY: {
                        this.appendToAfterStartDocumentReady("   ");
                        this.appendToAfterStartDocumentReady(content);
                        break;
                    }
                    case BEFOREENDDOCUMENTREADY: {
                        this.appendToAfterStartDocumentReady("   ");
                        this.appendToBeforeEndDocumentReady(content);
                        break;
                    }
                    case AFTERALL: {
                        this.appendToAfterAll(content);
                        break;
                    }
                    case BEFORESTARTDOCUMENTREADY: {
                        this.appendToBeforeStartDocumentReady(content);
                    }
                }
            }
        }
    }
}

