/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.datatables.core.configuration.DatatableBundles;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.extension.feature.FilterPlaceholder;
import com.github.dandelion.datatables.core.generator.configuration.ColumnFilteringGenerator;
import com.github.dandelion.datatables.core.html.HtmlTable;

public abstract class AbstractFilteringFeature
extends AbstractExtension {
    @Override
    public String getName() {
        return "filtering";
    }

    @Override
    public void setup(HtmlTable table) {
        this.addBundle(DatatableBundles.DDL_DT_FILTERING);
        FilterPlaceholder filterPlaceHolder = TableConfig.FEATURE_FILTER_PLACEHOLDER.valueFrom(table);
        if (filterPlaceHolder != null) {
            switch (filterPlaceHolder) {
                case FOOT: {
                    this.adaptFooter(table);
                    break;
                }
                case HEAD_AFTER: {
                    this.adaptHeader(table);
                    break;
                }
                case HEAD_BEFORE: {
                    this.adaptHeader(table);
                    break;
                }
            }
        } else {
            this.adaptFooter(table);
        }
        this.setFunction("columnFilter");
        this.setConfigGenerator(new ColumnFilteringGenerator());
    }

    protected abstract void adaptHeader(HtmlTable var1);

    protected abstract void adaptFooter(HtmlTable var1);
}

