/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension;

import com.github.dandelion.datatables.core.asset.JavascriptFunction;
import com.github.dandelion.datatables.core.asset.JavascriptSnippet;
import com.github.dandelion.datatables.core.asset.JsResource;
import com.github.dandelion.datatables.core.asset.Parameter;
import com.github.dandelion.datatables.core.exception.ExtensionLoadingException;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.util.JsonIndentingWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionProcessor {
    private static Logger logger = LoggerFactory.getLogger(ExtensionProcessor.class);
    private HtmlTable table;
    private JsResource mainJsFile;
    private Map<String, Object> mainConfig;

    public ExtensionProcessor(HtmlTable table, JsResource mainJsFile, Map<String, Object> mainConfig) {
        this.table = table;
        this.mainJsFile = mainJsFile;
        this.mainConfig = mainConfig;
    }

    public void process(Collection<Extension> extensions) {
        if (extensions != null && !extensions.isEmpty()) {
            for (Extension extension : extensions) {
                this.process(extension);
            }
        }
    }

    public void process(Extension extension) {
        if (extension != null) {
            extension.setupWrapper(this.table);
            this.injectIntoMainJsFile(extension);
            this.injectIntoMainConfiguration(extension);
        }
    }

    private void injectIntoMainJsFile(Extension extension) {
        if (extension.getBeforeAll() != null) {
            this.mainJsFile.appendToBeforeAll(extension.getBeforeAll().toString());
        }
        if (extension.getBeforeStartDocumentReady() != null) {
            this.mainJsFile.appendToBeforeStartDocumentReady(extension.getBeforeStartDocumentReady().toString());
        }
        if (extension.getAfterStartDocumentReady() != null) {
            this.mainJsFile.appendToAfterStartDocumentReady(extension.getAfterStartDocumentReady().toString());
        }
        if (extension.getBeforeEndDocumentReady() != null) {
            this.mainJsFile.appendToBeforeEndDocumentReady(extension.getBeforeEndDocumentReady().toString());
        }
        if (extension.getAfterAll() != null) {
            this.mainJsFile.appendToAfterAll(extension.getAfterAll().toString());
        }
        if (extension.getFunction() != null) {
            this.mainJsFile.appendToDataTablesExtra(extension.getFunction());
        }
        if (extension.getConfigGenerator() != null) {
            logger.debug("Custom configuration generator used: {}", (Object)extension.getConfigGenerator().getClass().getSimpleName());
            JsonIndentingWriter writer = new JsonIndentingWriter();
            Map<String, Object> conf = extension.getConfigGenerator().generateConfig(this.table);
            try {
                JSONValue.writeJSONString(conf, (Writer)writer);
            }
            catch (IOException e) {
                throw new ExtensionLoadingException("Unable to convert the configuration into JSON", e);
            }
            this.mainJsFile.appendToDataTablesExtraConf(((Object)writer).toString());
        }
    }

    private void injectIntoMainConfiguration(Extension extension) {
        if (extension.getParameters() != null) {
            for (Parameter param : extension.getParameters()) {
                if (this.mainConfig.containsKey(param.getName())) {
                    if (this.mainConfig.get(param.getName()) instanceof JavascriptFunction) {
                        this.processJavascriptFunction(param);
                        continue;
                    }
                    if (this.mainConfig.get(param.getName()) instanceof JavascriptSnippet) {
                        this.processJavascriptSnippet(param);
                        continue;
                    }
                    this.processString(param);
                    continue;
                }
                this.mainConfig.put(param.getName(), param.getValue());
            }
        }
    }

    private void processJavascriptFunction(Parameter conf) {
        JavascriptFunction jsFunction = (JavascriptFunction)this.mainConfig.get(conf.getName());
        StringBuilder newValue = null;
        switch (conf.getMode()) {
            case OVERRIDE: {
                this.mainConfig.put(conf.getName(), conf.getValue());
                break;
            }
            case APPEND: {
                newValue = new StringBuilder(((JavascriptFunction)conf.getValue()).getCode());
                newValue.append('\n').append("   ").append("   ");
                newValue.append(jsFunction.getCode());
                jsFunction.setCode(newValue.toString());
                this.mainConfig.put(conf.getName(), jsFunction);
                break;
            }
            case PREPEND: {
                newValue = new StringBuilder(jsFunction.getCode());
                newValue.append(((JavascriptFunction)conf.getValue()).getCode());
                jsFunction.setCode(newValue.toString());
                this.mainConfig.put(conf.getName(), jsFunction);
                break;
            }
            case APPEND_WITH_SPACE: {
                newValue = new StringBuilder(((JavascriptFunction)conf.getValue()).getCode());
                newValue.append(" ");
                newValue.append(jsFunction.getCode());
                jsFunction.setCode(newValue.toString());
                this.mainConfig.put(conf.getName(), jsFunction);
                break;
            }
            case PREPEND_WITH_SPACE: {
                newValue = new StringBuilder(jsFunction.getCode());
                newValue.append(" ");
                newValue.append(((JavascriptFunction)conf.getValue()).getCode());
                jsFunction.setCode(newValue.toString());
                this.mainConfig.put(conf.getName(), jsFunction);
                break;
            }
        }
    }

    private void processJavascriptSnippet(Parameter conf) {
        JavascriptSnippet jsSnippet = (JavascriptSnippet)this.mainConfig.get(conf.getName());
        String newValue = null;
        switch (conf.getMode()) {
            case OVERRIDE: {
                this.mainConfig.put(conf.getName(), conf.getValue());
                break;
            }
            case APPEND: {
                newValue = ((JavascriptSnippet)conf.getValue()).getJavascript() + jsSnippet.getJavascript();
                jsSnippet.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsSnippet);
                break;
            }
            case PREPEND: {
                newValue = jsSnippet.getJavascript() + ((JavascriptSnippet)conf.getValue()).getJavascript();
                jsSnippet.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsSnippet);
                break;
            }
            case APPEND_WITH_SPACE: {
                newValue = ((JavascriptSnippet)conf.getValue()).getJavascript() + " " + jsSnippet.getJavascript();
                jsSnippet.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsSnippet);
                break;
            }
            case PREPEND_WITH_SPACE: {
                newValue = jsSnippet.getJavascript() + " " + ((JavascriptSnippet)conf.getValue()).getJavascript();
                jsSnippet.setJavascript(newValue);
                this.mainConfig.put(conf.getName(), jsSnippet);
                break;
            }
        }
    }

    private void processString(Parameter conf) {
        String value = null;
        switch (conf.getMode()) {
            case OVERRIDE: {
                this.mainConfig.put(conf.getName(), conf.getValue());
                break;
            }
            case APPEND: {
                value = (String)this.mainConfig.get(conf.getName());
                value = value + conf.getValue();
                this.mainConfig.put(conf.getName(), value);
                break;
            }
            case PREPEND: {
                value = (String)this.mainConfig.get(conf.getName());
                value = conf.getValue() + value;
                this.mainConfig.put(conf.getName(), value);
                break;
            }
            case APPEND_WITH_SPACE: {
                value = (String)this.mainConfig.get(conf.getName());
                value = value + " " + conf.getValue();
                this.mainConfig.put(conf.getName(), value);
                break;
            }
            case PREPEND_WITH_SPACE: {
                value = (String)this.mainConfig.get(conf.getName());
                value = conf.getValue() + " " + value;
                this.mainConfig.put(conf.getName(), value);
                break;
            }
        }
    }
}

