/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.export;

import com.github.dandelion.core.utils.ClassUtils;
import com.github.dandelion.datatables.core.exception.ExportException;
import com.github.dandelion.datatables.core.export.DatatablesExport;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ExportUtils {
    public static final String DDL_DT_REQUESTATTR_EXPORT_CONF = "ddl-dt-export-conf";
    public static final String DDL_DT_REQUESTATTR_EXPORT_CONTENT = "ddl-dt-export-content";
    public static final String DDL_DT_REQUESTPARAM_EXPORT_IN_PROGRESS = "dtp";
    public static final String DDL_DT_REQUESTPARAM_EXPORT_TYPE = "dtt";
    public static final String DDL_DT_REQUESTPARAM_EXPORT_ID = "dti";
    public static final String DDL_DT_REQUESTPARAM_EXPORT_FORMAT = "dtf";
    public static final String DDL_DT_REQUESTPARAM_EXPORT_ORIENTATION = "dto";
    public static final String DDL_DT_REQUESTPARAM_EXPORT_HEADER = "dth";
    public static final String DDL_DT_REQUESTPARAM_EXPORT_MIME_TYPE = "dtmt";
    public static final String DDL_DT_REQUESTPARAM_EXPORT_EXTENSION = "dte";
    public static final String DDL_DT_REQUESTPARAM_EXPORT_NAME = "dtn";
    public static final String DDL_DT_REQUESTPARAM_EXPORT_AUTOSIZE = "dts";

    public static void renderExport(HtmlTable table, ExportConf exportConf, HttpServletResponse response) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        String exportClass = exportConf.getExportClass();
        if (!ClassUtils.isPresent((String)exportClass)) {
            throw new ExportException("Unable to export in " + exportConf.getFormat() + " format because the export class cannot be found. Did you forget to add an extra dependency?");
        }
        Class klass = null;
        DatatablesExport export = null;
        try {
            klass = ClassUtils.getClass((String)exportClass);
            export = (DatatablesExport)ClassUtils.getNewInstance((Class)klass);
        }
        catch (ClassNotFoundException e) {
            throw new ExportException("Unable to load the class '" + exportClass + "'", e);
        }
        catch (InstantiationException e) {
            throw new ExportException("Unable to instanciate the class '" + exportClass + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new ExportException("Unable to access the class '" + exportClass + "'", e);
        }
        export.initExport(table);
        export.processExport(stream);
        try {
            ExportUtils.writeToResponse(response, stream, exportConf.getFileName() + "." + exportConf.getFileExtension(), exportConf.getMimeType());
        }
        catch (IOException e) {
            throw new ExportException("Unable to write to response using the " + exportClass.getClass().getSimpleName(), e);
        }
    }

    public static void writeToResponse(HttpServletResponse response, ByteArrayOutputStream baos, String title, String contentType) throws IOException {
        response.setContentType(contentType);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + title + "\"");
        ServletOutputStream out = response.getOutputStream();
        baos.writeTo((OutputStream)out);
        out.flush();
    }

    public static String getCurrentExportType(HttpServletRequest request) {
        String exportTypeString = request.getParameter(DDL_DT_REQUESTPARAM_EXPORT_FORMAT).toString();
        return exportTypeString;
    }

    public static Boolean isTableBeingExported(ServletRequest servletRequest, HtmlTable table) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        Object exportInProgress = request.getAttribute(DDL_DT_REQUESTPARAM_EXPORT_IN_PROGRESS);
        return exportInProgress != null && exportInProgress.equals("true");
    }

    private ExportUtils() {
    }
}

