/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.export;

import com.github.dandelion.core.utils.EnumUtils;
import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.exception.ConfigurationProcessingException;
import com.github.dandelion.datatables.core.export.DatatablesExport;
import com.github.dandelion.datatables.core.export.HttpMethod;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpServletRequest;

public class ExportConf {
    public static final String DEFAULT_CSV_CLASS = "com.github.dandelion.datatables.core.export.CsvExport";
    public static final String DEFAULT_XML_CLASS = "com.github.dandelion.datatables.core.export.XmlExport";
    public static final String DEFAULT_PDF_CLASS = "com.github.dandelion.datatables.extras.export.itext.PdfExport";
    public static final String DEFAULT_XLS_CLASS = "com.github.dandelion.datatables.extras.export.poi.XlsExport";
    public static final String DEFAULT_XLSX_CLASS = "com.github.dandelion.datatables.extras.export.poi.XlsxExport";
    private String format;
    private String fileName;
    private String fileExtension;
    private String mimeType;
    private String label;
    private StringBuilder cssStyle;
    private StringBuilder cssClass;
    private Boolean includeHeader;
    private String url;
    private HttpMethod method;
    private Boolean autoSize;
    private Boolean hasCustomUrl = false;
    private String exportClass;
    private Orientation orientation;

    public ExportConf(String format) {
        this.format = format;
        this.init();
    }

    public ExportConf(HttpServletRequest request) {
        String format = request.getParameter("dtf");
        if (StringUtils.isNotBlank((String)format)) {
            this.format = format;
        }
        this.init();
        this.overrideWithRequest(request);
    }

    public ExportConf(String format, String exportUrl) {
        this.format = format;
        this.url = exportUrl;
        this.init();
    }

    private void init() {
        if (StringUtils.isBlank((String)this.fileName)) {
            this.fileName = "export-" + this.format + "-" + new SimpleDateFormat("yyyymmDD").format(new GregorianCalendar().getTime());
        }
        if (StringUtils.isBlank((String)this.label) && StringUtils.isNotBlank((String)this.format)) {
            this.label = this.format.toUpperCase();
        }
        if (this.includeHeader == null) {
            this.includeHeader = true;
        }
        if (this.autoSize == null) {
            this.autoSize = true;
        }
        if (this.method == null) {
            this.method = HttpMethod.GET;
        }
        if (StringUtils.isBlank((String)this.fileExtension)) {
            this.fileExtension = this.format;
        }
        if ("csv".equals(this.format)) {
            this.exportClass = DEFAULT_CSV_CLASS;
            this.mimeType = "text/csv";
        }
        if ("xml".equals(this.format)) {
            this.exportClass = DEFAULT_XML_CLASS;
            this.mimeType = "text/xml";
        }
        if ("pdf".equals(this.format)) {
            this.exportClass = DEFAULT_PDF_CLASS;
            this.mimeType = "application/pdf";
            this.orientation = Orientation.LANDSCAPE;
        }
        if ("xls".equals(this.format)) {
            this.exportClass = DEFAULT_XLS_CLASS;
            this.mimeType = "application/vnd.ms-excel";
        }
        if ("xlsx".equals(this.format)) {
            this.exportClass = DEFAULT_XLSX_CLASS;
            this.mimeType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
    }

    private void overrideWithRequest(HttpServletRequest request) {
        String autosize;
        String fileName;
        String fileExtension;
        String mimeType;
        String includeHeader;
        String orientation = request.getParameter("dto");
        if (StringUtils.isNotBlank((String)orientation)) {
            Orientation orientationEnum = null;
            try {
                orientationEnum = Orientation.valueOf(orientation.toUpperCase().trim());
            }
            catch (IllegalArgumentException e) {
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                sb.append((Object)this.orientation);
                sb.append("' is not a valid orientation. Possible values are: ");
                sb.append(EnumUtils.printPossibleValuesOf(Orientation.class));
                throw new ConfigurationProcessingException(sb.toString());
            }
            this.orientation = orientationEnum;
        }
        if (StringUtils.isNotBlank((String)(includeHeader = request.getParameter("dth")))) {
            this.includeHeader = Boolean.parseBoolean(includeHeader.trim());
        }
        if (StringUtils.isNotBlank((String)(mimeType = request.getParameter("dtmt")))) {
            this.mimeType = mimeType.trim();
        }
        if (StringUtils.isNotBlank((String)(fileExtension = request.getParameter("dte")))) {
            this.fileExtension = fileExtension.trim();
        }
        if (StringUtils.isNotBlank((String)(fileName = request.getParameter("dtn")))) {
            this.fileName = fileName.trim();
        }
        if (StringUtils.isNotBlank((String)(autosize = request.getParameter("dts")))) {
            this.autoSize = Boolean.parseBoolean(autosize);
        }
    }

    public void mergeWith(ExportConf exportConfToMergeFrom) {
        if (exportConfToMergeFrom.getIncludeHeader() != null) {
            this.includeHeader = exportConfToMergeFrom.getIncludeHeader();
        }
        if (exportConfToMergeFrom.getAutoSize() != null) {
            this.autoSize = exportConfToMergeFrom.getAutoSize();
        }
        if (StringUtils.isNotBlank((String)exportConfToMergeFrom.getFileExtension())) {
            this.fileExtension = exportConfToMergeFrom.getFileExtension();
        }
        if (StringUtils.isNotBlank((String)exportConfToMergeFrom.getMimeType())) {
            this.mimeType = exportConfToMergeFrom.getMimeType();
        }
        if (exportConfToMergeFrom.getMethod() != null) {
            this.method = exportConfToMergeFrom.getMethod();
        }
        if (StringUtils.isNotBlank((String)exportConfToMergeFrom.getFileName())) {
            this.fileName = exportConfToMergeFrom.getFileName();
        }
        if (exportConfToMergeFrom.getOrientation() != null) {
            this.orientation = exportConfToMergeFrom.getOrientation();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public StringBuilder getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(StringBuilder cssStyle) {
        this.cssStyle = cssStyle;
    }

    public StringBuilder getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(StringBuilder cssClass) {
        this.cssClass = cssClass;
    }

    public Boolean getIncludeHeader() {
        return this.includeHeader;
    }

    public void setIncludeHeader(Boolean includeHeader) {
        this.includeHeader = includeHeader;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Boolean hasCustomUrl() {
        return this.hasCustomUrl;
    }

    public void setHasCustomUrl(Boolean custom) {
        this.hasCustomUrl = custom;
    }

    public Boolean getAutoSize() {
        return this.autoSize;
    }

    public void setAutoSize(Boolean autoSize) {
        this.autoSize = autoSize;
    }

    public String getExportClass() {
        return this.exportClass;
    }

    public void setExportClass(String exportClass) {
        this.exportClass = exportClass;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public String toString() {
        return "ExportConf [format=" + this.format + ", fileName=" + this.fileName + ", fileExtension=" + this.fileExtension + ", mimeType=" + this.mimeType + ", label=" + this.label + ", cssStyle=" + this.cssStyle + ", cssClass=" + this.cssClass + ", includeHeader=" + this.includeHeader + ", url=" + this.url + ", method=" + (Object)((Object)this.method) + ", autoSize=" + this.autoSize + ", hasCustomUrl=" + this.hasCustomUrl + ", exportClass=" + this.exportClass + ", orientation=" + (Object)((Object)this.orientation) + "]";
    }

    public static class Builder {
        private ExportConf exportConf;

        public Builder(String format) {
            this.exportConf = new ExportConf(format);
        }

        public Builder mimeType(String mimeType) {
            this.exportConf.setMimeType(mimeType);
            return this;
        }

        public Builder fileExtension(String fileExtension) {
            this.exportConf.setFileExtension(fileExtension);
            return this;
        }

        public Builder fileName(String fileName) {
            this.exportConf.setFileName(fileName);
            return this;
        }

        public Builder header(Boolean header) {
            this.exportConf.setIncludeHeader(header);
            return this;
        }

        public Builder autoSize(Boolean autoSize) {
            this.exportConf.setAutoSize(autoSize);
            return this;
        }

        public Builder exportClass(String exportClass) {
            this.exportConf.setExportClass(exportClass);
            return this;
        }

        public Builder exportClass(DatatablesExport exportClass) {
            this.exportConf.setExportClass(exportClass.getClass().getName());
            return this;
        }

        public Builder orientation(Orientation orientation) {
            this.exportConf.setOrientation(orientation);
            return this;
        }

        public ExportConf build() {
            return this.exportConf;
        }
    }

    public static enum Orientation {
        PORTRAIT,
        LANDSCAPE;

    }
}

