/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.configuration;

import com.github.dandelion.datatables.core.asset.ExtraJs;
import com.github.dandelion.datatables.core.callback.Callback;
import com.github.dandelion.datatables.core.callback.CallbackType;
import com.github.dandelion.datatables.core.configuration.ConfigToken;
import com.github.dandelion.datatables.core.configuration.ConfigurationStore;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.html.ExtraHtml;
import com.github.dandelion.datatables.core.i18n.MessageResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TableConfiguration {
    private Map<ConfigToken<?>, Object> configurations;
    private Map<ConfigToken<?>, Object> stagingConfiguration;
    private Map<String, ExportConf> exportConfiguration;
    private Set<ExtraJs> extraJs;
    private List<Callback> extraCallbacks;
    private List<ExtraHtml> extraHtmls;
    private Boolean exporting;
    private Boolean isExportable = false;
    private String currentExportFormat;
    private Properties messages = new Properties();
    private MessageResolver messageResolver;
    private Set<Extension> internalExtensions;
    private String tableId;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public static TableConfiguration getInstance(String tableId, HttpServletRequest request) {
        return TableConfiguration.getInstance(tableId, request, "global");
    }

    public static TableConfiguration getInstance(String tableId, HttpServletRequest request, String groupName) {
        TableConfiguration prototype = ConfigurationStore.getPrototype(request, groupName);
        return new TableConfiguration(tableId, prototype, request);
    }

    public TableConfiguration(Map<ConfigToken<?>, Object> userConf, MessageResolver messageResolver, HttpServletRequest request) {
        this.request = request;
        this.messageResolver = messageResolver;
        this.configurations = userConf;
        this.stagingConfiguration = new HashMap();
        this.exportConfiguration = new LinkedHashMap<String, ExportConf>();
    }

    private TableConfiguration(String tableId, TableConfiguration objectToClone, HttpServletRequest request) {
        this.request = request;
        this.tableId = tableId;
        this.messageResolver = objectToClone.messageResolver;
        this.configurations = objectToClone.configurations;
        this.stagingConfiguration = objectToClone.stagingConfiguration;
        this.exportConfiguration = objectToClone.exportConfiguration;
        this.extraJs = objectToClone.extraJs;
        this.extraCallbacks = objectToClone.extraCallbacks;
        this.extraHtmls = objectToClone.extraHtmls;
        this.exporting = objectToClone.exporting;
        this.isExportable = objectToClone.isExportable;
        this.messages = objectToClone.messages;
    }

    public void set(String exportFormat, ExportConf exportConf) {
        this.exportConfiguration.put(exportFormat, exportConf);
    }

    public Map<String, ExportConf> getExportConfiguration() {
        return this.exportConfiguration;
    }

    public void setExportConfiguration(Map<String, ExportConf> exports) {
        this.exportConfiguration = exports;
    }

    public void set(ConfigToken<?> configToken, Object object) {
        this.configurations.put(configToken, object);
    }

    public Map<ConfigToken<?>, Object> getConfigurations() {
        return this.configurations;
    }

    public void setConfig(Map<ConfigToken<?>, Object> configurations2) {
        this.configurations = configurations2;
    }

    public TableConfiguration registerExtension(Extension extension) {
        if (this.internalExtensions == null) {
            this.internalExtensions = new HashSet<Extension>();
        }
        this.internalExtensions.add(extension);
        return this;
    }

    public Set<ExtraJs> getExtraJs() {
        return this.extraJs;
    }

    public TableConfiguration addExtraJs(ExtraJs extraJs) {
        if (this.extraJs == null) {
            this.extraJs = new HashSet<ExtraJs>();
        }
        this.extraJs.add(extraJs);
        return this;
    }

    public void setExtraJs(Set<ExtraJs> extraJs) {
        this.extraJs = extraJs;
    }

    public Set<Extension> getInternalExtensions() {
        return this.internalExtensions;
    }

    public TableConfiguration setInternalExtensions(Set<Extension> extensions) {
        this.internalExtensions = extensions;
        return this;
    }

    public List<Callback> getCallbacks() {
        return this.extraCallbacks;
    }

    public void setCallbacks(List<Callback> callbacks) {
        this.extraCallbacks = callbacks;
    }

    public TableConfiguration registerCallback(Callback callback) {
        if (this.extraCallbacks == null) {
            this.extraCallbacks = new ArrayList<Callback>();
        }
        this.extraCallbacks.add(callback);
        return this;
    }

    public Boolean hasCallback(CallbackType callbackType) {
        if (this.extraCallbacks != null) {
            for (Callback callback : this.extraCallbacks) {
                if (!callback.getType().equals((Object)callbackType)) continue;
                return true;
            }
        }
        return false;
    }

    public Callback getCallback(CallbackType callbackType) {
        for (Callback callback : this.extraCallbacks) {
            if (!callback.getType().equals((Object)callbackType)) continue;
            return callback;
        }
        return null;
    }

    public Boolean getExporting() {
        return this.exporting;
    }

    public void setExporting(Boolean exporting) {
        this.exporting = exporting;
    }

    public Boolean isExportable() {
        return this.isExportable;
    }

    public void setIsExportable(Boolean isExportable) {
        this.isExportable = isExportable;
    }

    public TableConfiguration setExportTypes(String exportTypes) {
        return this;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public TableConfiguration addCssStyle(String cssStyle) {
        if (TableConfig.CSS_STYLE.valueFrom(this) == null) {
            TableConfig.CSS_STYLE.setIn(this, new StringBuilder());
        } else {
            TableConfig.CSS_STYLE.appendIn(this, ';');
        }
        TableConfig.CSS_STYLE.appendIn(this, cssStyle);
        return this;
    }

    public TableConfiguration addCssClass(String cssClass) {
        if (TableConfig.CSS_CLASS.valueFrom(this) == null) {
            TableConfig.CSS_CLASS.setIn(this, new StringBuilder());
        } else {
            TableConfig.CSS_CLASS.appendIn(this, ' ');
        }
        TableConfig.CSS_CLASS.appendIn(this, cssClass);
        return this;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ExportConf getExportConf(String format) {
        return this.exportConfiguration.get(format);
    }

    public Properties getMessages() {
        return this.messages;
    }

    public MessageResolver getMessageResolver() {
        return this.messageResolver;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setMessages(Properties messages) {
        this.messages = messages;
    }

    public String getMessage(String key) {
        return this.messages.getProperty(key);
    }

    public List<ExtraHtml> getExtraHtmlSnippets() {
        return this.extraHtmls;
    }

    public void setExtraHtmlSnippets(List<ExtraHtml> linkGroups) {
        this.extraHtmls = linkGroups;
    }

    public void addExtraHtmlSnippet(ExtraHtml extraHtml) {
        if (this.extraHtmls == null) {
            this.extraHtmls = new ArrayList<ExtraHtml>();
        }
        this.extraHtmls.add(extraHtml);
    }

    public String getCurrentExportFormat() {
        return this.currentExportFormat;
    }

    public void setCurrentExportFormat(String currentExport) {
        this.currentExportFormat = currentExport;
    }

    public Map<ConfigToken<?>, Object> getStagingConfiguration() {
        return this.stagingConfiguration;
    }

    public void setStagingConfiguration(Map<ConfigToken<?>, Object> stagingConfiguration) {
        this.stagingConfiguration = stagingConfiguration;
    }

    public void addStagingConf(ConfigToken<?> configToken, Object value) {
        this.stagingConfiguration.put(configToken, value);
    }
}

