/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.configuration;

import com.github.dandelion.datatables.core.configuration.ConfigToken;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.extension.feature.FilterPlaceholder;
import com.github.dandelion.datatables.core.extension.feature.PaginationType;
import com.github.dandelion.datatables.core.extension.theme.ThemeOption;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.processor.BooleanProcessor;
import com.github.dandelion.datatables.core.processor.ConfigurationProcessor;
import com.github.dandelion.datatables.core.processor.IntegerProcessor;
import com.github.dandelion.datatables.core.processor.StringBuilderProcessor;
import com.github.dandelion.datatables.core.processor.StringProcessor;
import com.github.dandelion.datatables.core.processor.ajax.AjaxPipeliningProcessor;
import com.github.dandelion.datatables.core.processor.ajax.AjaxReloadFunctionProcessor;
import com.github.dandelion.datatables.core.processor.ajax.AjaxReloadProcessor;
import com.github.dandelion.datatables.core.processor.ajax.AjaxServerSideProcessor;
import com.github.dandelion.datatables.core.processor.ajax.AjaxSourceProcessor;
import com.github.dandelion.datatables.core.processor.css.CssStripeClassesProcessor;
import com.github.dandelion.datatables.core.processor.css.CssThemeOptionProcessor;
import com.github.dandelion.datatables.core.processor.css.CssThemeProcessor;
import com.github.dandelion.datatables.core.processor.export.ExportEnabledFormatProcessor;
import com.github.dandelion.datatables.core.processor.export.ExportFormatProcessor;
import com.github.dandelion.datatables.core.processor.feature.FeatureAppearProcessor;
import com.github.dandelion.datatables.core.processor.feature.FeatureFilterPlaceholderProcessor;
import com.github.dandelion.datatables.core.processor.feature.FeatureFilterSelectorProcessor;
import com.github.dandelion.datatables.core.processor.feature.FeatureLengthMenuProcessor;
import com.github.dandelion.datatables.core.processor.feature.FeaturePaginationTypeProcessor;
import com.github.dandelion.datatables.core.processor.i18n.MessageProcessor;
import com.github.dandelion.datatables.core.processor.main.MainExtensionNamesProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class TableConfig {
    private static Map<String, ConfigToken<?>> internalConf;
    public static final String P_MAIN_EXTENSION_PACKAGE = "main.extension.package";
    public static final String P_MAIN_EXTENSION_NAMES = "main.extension.names";
    public static final String P_CSS_CLASS = "css.class";
    public static final String P_CSS_STYLE = "css.style";
    public static final String P_CSS_STRIPECLASSES = "css.stripeClasses";
    public static final String P_CSS_THEME = "css.theme";
    public static final String P_CSS_THEMEOPTION = "css.themeOption";
    public static final String P_FEATURE_INFO = "feature.info";
    public static final String P_FEATURE_AUTOWIDTH = "feature.autoWidth";
    public static final String P_FEATURE_FILTERABLE = "feature.filterable";
    public static final String P_FEATURE_FILTER_PLACEHOLDER = "feature.filterPlaceHolder";
    public static final String P_FEATURE_FILTER_DELAY = "feature.filterDelay";
    public static final String P_FEATURE_FILTER_SELECTOR = "feature.filterSelector";
    public static final String P_FEATURE_FILTER_CLEAR_SELECTOR = "feature.filterClearSelector";
    public static final String P_FEATURE_FILTER_TRIGGER = "feature.filterTrigger";
    public static final String P_FEATURE_PAGEABLE = "feature.pageable";
    public static final String P_FEATURE_PAGINATIONTYPE = "feature.paginationType";
    public static final String P_FEATURE_LENGTHCHANGE = "feature.lengthChange";
    public static final String P_FEATURE_SORTABLE = "feature.sortable";
    public static final String P_FEATURE_STATESAVE = "feature.stateSave";
    public static final String P_FEATURE_JQUERYUI = "feature.jqueryUi";
    public static final String P_FEATURE_LENGTHMENU = "feature.lengthMenu";
    public static final String P_FEATURE_DISPLAYLENGTH = "feature.displayLength";
    public static final String P_FEATURE_DOM = "feature.dom";
    public static final String P_FEATURE_SCROLLY = "feature.scrollY";
    public static final String P_FEATURE_SCROLLCOLLAPSE = "feature.scrollCollapse";
    public static final String P_FEATURE_SCROLLX = "feature.scrollX";
    public static final String P_FEATURE_SCROLLXINNER = "feature.scrollXInner";
    public static final String P_FEATURE_APPEAR = "feature.appear";
    public static final String P_FEATURE_APPEAR_DURATION = "feature.appearDuration";
    public static final String P_FEATURE_PROCESSING = "feature.processing";
    public static final String P_AJAX_DEFERRENDER = "ajax.deferRender";
    public static final String P_AJAX_SERVERSIDE = "ajax.serverSide";
    public static final String P_AJAX_SOURCE = "ajax.source";
    public static final String P_AJAX_PIPELINING = "ajax.pipelining";
    public static final String P_AJAX_PIPESIZE = "ajax.pipeSize";
    public static final String P_AJAX_SERVERDATA = "ajax.serverData";
    public static final String P_AJAX_SERVERPARAM = "ajax.serverParam";
    public static final String P_AJAX_SERVERMETHOD = "ajax.serverMethod";
    public static final String P_AJAX_RELOAD_SELECTOR = "ajax.reloadSelector";
    public static final String P_AJAX_RELOAD_FUNCTION = "ajax.reloadFunction";
    public static final String P_PLUGIN_FIXEDPOSITION = "plugin.fixedPosition";
    public static final String P_PLUGIN_FIXEDOFFSETTOP = "plugin.fixedOffsetTop";
    public static final String P_EXPORT_ENABLED_FORMATS = "export.enabled.formats";
    public static final String P_EXPORT_LINK_POSITIONS = "export.link.positions";
    public static final String P_EXPORT_CONTAINER_STYLE = "export.container.style";
    public static final String P_EXPORT_CONTAINER_CLASS = "export.container.class";
    public static final String P_I18N_MSG_PROCESSING = "i18n.msg.processing";
    public static final String P_I18N_MSG_SEARCH = "i18n.msg.search";
    public static final String P_I18N_MSG_LENGTHMENU = "i18n.msg.lengthmenu";
    public static final String P_I18N_MSG_INFO = "i18n.msg.info";
    public static final String P_I18N_MSG_INFOEMPTY = "i18n.msg.info.empty";
    public static final String P_I18N_MSG_INFOFILTERED = "i18n.msg.info.filtered";
    public static final String P_I18N_MSG_INFOPOSTFIX = "i18n.msg.info.postfix";
    public static final String P_I18N_MSG_LOADINGRECORDS = "i18n.msg.loadingrecords";
    public static final String P_I18N_MSG_ZERORECORDS = "i18n.msg.zerorecords";
    public static final String P_I18N_MSG_EMPTYTABLE = "i18n.msg.emptytable";
    public static final String P_I18N_MSG_PAGINATE_FIRST = "i18n.msg.paginate.first";
    public static final String P_I18N_MSG_PAGINATE_PREVIOUS = "i18n.msg.paginate.previous";
    public static final String P_I18N_MSG_PAGINATE_NEXT = "i18n.msg.paginate.next";
    public static final String P_I18N_MSG_PAGINATE_LAST = "i18n.msg.paginate.last";
    public static final String P_I18N_MSG_ARIA_SORTASC = "i18n.msg.aria.sortasc";
    public static final String P_I18N_MSG_ARIA_SORTDESC = "i18n.msg.aria.sortdesc";
    public static ConfigToken<String> MAIN_EXTENSION_PACKAGE;
    public static ConfigToken<Set<String>> MAIN_EXTENSION_NAMES;
    public static ConfigToken<StringBuilder> CSS_CLASS;
    public static ConfigToken<StringBuilder> CSS_STYLE;
    public static ConfigToken<String> CSS_STRIPECLASSES;
    public static ConfigToken<Extension> CSS_THEME;
    public static ConfigToken<ThemeOption> CSS_THEMEOPTION;
    public static ConfigToken<Boolean> FEATURE_INFO;
    public static ConfigToken<Boolean> FEATURE_AUTOWIDTH;
    public static ConfigToken<Boolean> FEATURE_FILTERABLE;
    public static ConfigToken<FilterPlaceholder> FEATURE_FILTER_PLACEHOLDER;
    public static ConfigToken<Integer> FEATURE_FILTER_DELAY;
    public static ConfigToken<String> FEATURE_FILTER_SELECTOR;
    public static ConfigToken<String> FEATURE_FILTER_CLEAR_SELECTOR;
    public static ConfigToken<String> FEATURE_FILTER_TRIGGER;
    public static ConfigToken<Boolean> FEATURE_PAGEABLE;
    public static ConfigToken<PaginationType> FEATURE_PAGINATIONTYPE;
    public static ConfigToken<Boolean> FEATURE_LENGTHCHANGE;
    public static ConfigToken<Boolean> FEATURE_SORTABLE;
    public static ConfigToken<Boolean> FEATURE_STATESAVE;
    public static ConfigToken<Boolean> FEATURE_JQUERYUI;
    public static ConfigToken<String> FEATURE_LENGTHMENU;
    public static ConfigToken<Integer> FEATURE_DISPLAYLENGTH;
    public static ConfigToken<String> FEATURE_DOM;
    public static ConfigToken<String> FEATURE_SCROLLY;
    public static ConfigToken<Boolean> FEATURE_SCROLLCOLLAPSE;
    public static ConfigToken<String> FEATURE_SCROLLX;
    public static ConfigToken<String> FEATURE_SCROLLXINNER;
    public static ConfigToken<String> FEATURE_APPEAR;
    public static ConfigToken<String> FEATURE_APPEAR_DURATION;
    public static ConfigToken<Boolean> FEATURE_PROCESSING;
    public static ConfigToken<Boolean> AJAX_DEFERRENDER;
    public static ConfigToken<Boolean> AJAX_SERVERSIDE;
    public static ConfigToken<String> AJAX_SOURCE;
    public static ConfigToken<Boolean> AJAX_PIPELINING;
    public static ConfigToken<Integer> AJAX_PIPESIZE;
    public static ConfigToken<String> AJAX_SERVERDATA;
    public static ConfigToken<String> AJAX_SERVERPARAM;
    public static ConfigToken<String> AJAX_SERVERMETHOD;
    public static ConfigToken<String> AJAX_RELOAD_SELECTOR;
    public static ConfigToken<String> AJAX_RELOAD_FUNCTION;
    public static ConfigToken<String> PLUGIN_FIXEDPOSITION;
    public static ConfigToken<Integer> PLUGIN_FIXEDOFFSETTOP;
    public static ConfigToken<Set<ExportConf>> EXPORT_ENABLED_FORMATS;
    public static ConfigToken<String> EXPORT_CONTAINER_STYLE;
    public static ConfigToken<String> EXPORT_CONTAINER_CLASS;
    public static ConfigToken<String> EXPORT_CLASS;
    public static ConfigToken<String> EXPORT_LABEL;
    public static ConfigToken<String> EXPORT_FILENAME;
    public static ConfigToken<String> EXPORT_MIMETYPE;
    public static ConfigToken<String> I18N_MSG_PROCESSING;
    public static ConfigToken<String> I18N_MSG_SEARCH;
    public static ConfigToken<String> I18N_MSG_LENGTHMENU;
    public static ConfigToken<String> I18N_MSG_INFO;
    public static ConfigToken<String> I18N_MSG_INFOEMPTY;
    public static ConfigToken<String> I18N_MSG_INFOFILTERED;
    public static ConfigToken<String> I18N_MSG_INFOPOSTFIX;
    public static ConfigToken<String> I18N_MSG_LOADINGRECORDS;
    public static ConfigToken<String> I18N_MSG_ZERORECORDS;
    public static ConfigToken<String> I18N_MSG_EMPTYTABLE;
    public static ConfigToken<String> I18N_MSG_PAGINATE_FIRST;
    public static ConfigToken<String> I18N_MSG_PAGINATE_PREVIOUS;
    public static ConfigToken<String> I18N_MSG_PAGINATE_NEXT;
    public static ConfigToken<String> I18N_MSG_PAGINATE_LAST;
    public static ConfigToken<String> I18N_MSG_ARIA_SORTASC;
    public static ConfigToken<String> I18N_MSG_ARIA_SORTDESC;
    public static ConfigToken<String> INTERNAL_OBJECTTYPE;

    private static String formalize(String propertyName) {
        return propertyName.trim().toLowerCase();
    }

    public static ConfigToken<?> findByPropertyName(String propertyName) {
        if (internalConf.containsKey(propertyName)) {
            return internalConf.get(propertyName);
        }
        if (propertyName.contains("export")) {
            ConfigToken<String> exportConfigToken = null;
            Pattern patternExportClass = Pattern.compile("export\\.(.*?)\\.class", 2);
            if (patternExportClass.matcher(propertyName).find()) {
                exportConfigToken = EXPORT_CLASS;
                exportConfigToken.setPropertyName(propertyName);
                return exportConfigToken;
            }
            Pattern patternExportFilename = Pattern.compile("export\\.(.*?)\\.fileName", 2);
            if (patternExportFilename.matcher(propertyName).find()) {
                exportConfigToken = EXPORT_FILENAME;
                exportConfigToken.setPropertyName(propertyName);
                return exportConfigToken;
            }
            Pattern patternExportLabel = Pattern.compile("export\\.(.*?)\\.label", 2);
            if (patternExportLabel.matcher(propertyName).find()) {
                exportConfigToken = EXPORT_LABEL;
                exportConfigToken.setPropertyName(propertyName);
                return exportConfigToken;
            }
            Pattern patternExportMimetype = Pattern.compile("export\\.(.*?)\\.mimeType", 2);
            if (patternExportMimetype.matcher(propertyName).find()) {
                exportConfigToken = EXPORT_MIMETYPE;
                exportConfigToken.setPropertyName(propertyName);
                return exportConfigToken;
            }
        }
        return null;
    }

    public static Map<ConfigToken<?>, Object> applyConfiguration(Map<ConfigToken<?>, Object> stagingConf, HtmlTable table) {
        for (Map.Entry<ConfigToken<?>, Object> stagingEntry : stagingConf.entrySet()) {
            table.getTableConfiguration().getConfigurations().put(stagingEntry.getKey(), stagingEntry.getValue());
        }
        return stagingConf;
    }

    public static Map<ConfigToken<?>, Object> processConfiguration(HtmlTable table) {
        if (table.getTableConfiguration().getConfigurations() != null) {
            for (Map.Entry<ConfigToken<?>, Object> entry : table.getTableConfiguration().getConfigurations().entrySet()) {
                ConfigurationProcessor tableProcessor = entry.getKey().getProcessor();
                tableProcessor.process(entry, table.getTableConfiguration());
            }
            table.getTableConfiguration().getConfigurations().putAll(table.getTableConfiguration().getStagingConfiguration());
        }
        return table.getTableConfiguration().getConfigurations();
    }

    private TableConfig() {
    }

    static {
        MAIN_EXTENSION_PACKAGE = new ConfigToken(P_MAIN_EXTENSION_PACKAGE, new StringProcessor());
        MAIN_EXTENSION_NAMES = new ConfigToken(P_MAIN_EXTENSION_NAMES, new MainExtensionNamesProcessor());
        CSS_CLASS = new ConfigToken(P_CSS_CLASS, new StringBuilderProcessor());
        CSS_STYLE = new ConfigToken(P_CSS_STYLE, new StringBuilderProcessor());
        CSS_STRIPECLASSES = new ConfigToken(P_CSS_STRIPECLASSES, new CssStripeClassesProcessor());
        CSS_THEME = new ConfigToken(P_CSS_THEME, new CssThemeProcessor());
        CSS_THEMEOPTION = new ConfigToken(P_CSS_THEMEOPTION, new CssThemeOptionProcessor());
        FEATURE_INFO = new ConfigToken(P_FEATURE_INFO, new BooleanProcessor());
        FEATURE_AUTOWIDTH = new ConfigToken(P_FEATURE_AUTOWIDTH, new BooleanProcessor());
        FEATURE_FILTERABLE = new ConfigToken(P_FEATURE_FILTERABLE, new BooleanProcessor());
        FEATURE_FILTER_PLACEHOLDER = new ConfigToken(P_FEATURE_FILTER_PLACEHOLDER, new FeatureFilterPlaceholderProcessor());
        FEATURE_FILTER_DELAY = new ConfigToken(P_FEATURE_FILTER_DELAY, new IntegerProcessor());
        FEATURE_FILTER_SELECTOR = new ConfigToken(P_FEATURE_FILTER_SELECTOR, new FeatureFilterSelectorProcessor());
        FEATURE_FILTER_CLEAR_SELECTOR = new ConfigToken(P_FEATURE_FILTER_CLEAR_SELECTOR, new StringProcessor());
        FEATURE_FILTER_TRIGGER = new ConfigToken(P_FEATURE_FILTER_TRIGGER, new StringProcessor());
        FEATURE_PAGEABLE = new ConfigToken(P_FEATURE_PAGEABLE, new BooleanProcessor());
        FEATURE_PAGINATIONTYPE = new ConfigToken(P_FEATURE_PAGINATIONTYPE, new FeaturePaginationTypeProcessor());
        FEATURE_LENGTHCHANGE = new ConfigToken(P_FEATURE_LENGTHCHANGE, new BooleanProcessor());
        FEATURE_SORTABLE = new ConfigToken(P_FEATURE_SORTABLE, new BooleanProcessor());
        FEATURE_STATESAVE = new ConfigToken(P_FEATURE_STATESAVE, new BooleanProcessor());
        FEATURE_JQUERYUI = new ConfigToken(P_FEATURE_JQUERYUI, new BooleanProcessor());
        FEATURE_LENGTHMENU = new ConfigToken(P_FEATURE_LENGTHMENU, new FeatureLengthMenuProcessor());
        FEATURE_DISPLAYLENGTH = new ConfigToken(P_FEATURE_DISPLAYLENGTH, new IntegerProcessor());
        FEATURE_DOM = new ConfigToken(P_FEATURE_DOM, new StringProcessor());
        FEATURE_SCROLLY = new ConfigToken(P_FEATURE_SCROLLY, new StringProcessor());
        FEATURE_SCROLLCOLLAPSE = new ConfigToken(P_FEATURE_SCROLLCOLLAPSE, new BooleanProcessor());
        FEATURE_SCROLLX = new ConfigToken(P_FEATURE_SCROLLX, new StringProcessor());
        FEATURE_SCROLLXINNER = new ConfigToken(P_FEATURE_SCROLLXINNER, new StringProcessor());
        FEATURE_APPEAR = new ConfigToken(P_FEATURE_APPEAR, new FeatureAppearProcessor());
        FEATURE_APPEAR_DURATION = new ConfigToken(P_FEATURE_APPEAR_DURATION, null);
        FEATURE_PROCESSING = new ConfigToken(P_FEATURE_PROCESSING, new BooleanProcessor());
        AJAX_DEFERRENDER = new ConfigToken(P_AJAX_DEFERRENDER, new BooleanProcessor());
        AJAX_SERVERSIDE = new ConfigToken(P_AJAX_SERVERSIDE, new AjaxServerSideProcessor());
        AJAX_SOURCE = new ConfigToken(P_AJAX_SOURCE, new AjaxSourceProcessor());
        AJAX_PIPELINING = new ConfigToken(P_AJAX_PIPELINING, new AjaxPipeliningProcessor());
        AJAX_PIPESIZE = new ConfigToken(P_AJAX_PIPESIZE, new IntegerProcessor());
        AJAX_SERVERDATA = new ConfigToken(P_AJAX_SERVERDATA, new StringProcessor(true));
        AJAX_SERVERPARAM = new ConfigToken(P_AJAX_SERVERPARAM, new StringProcessor(true));
        AJAX_SERVERMETHOD = new ConfigToken(P_AJAX_SERVERMETHOD, new StringProcessor());
        AJAX_RELOAD_SELECTOR = new ConfigToken(P_AJAX_RELOAD_SELECTOR, new AjaxReloadProcessor());
        AJAX_RELOAD_FUNCTION = new ConfigToken(P_AJAX_RELOAD_FUNCTION, new AjaxReloadFunctionProcessor(true));
        PLUGIN_FIXEDPOSITION = new ConfigToken(P_PLUGIN_FIXEDPOSITION, new StringProcessor());
        PLUGIN_FIXEDOFFSETTOP = new ConfigToken(P_PLUGIN_FIXEDOFFSETTOP, new IntegerProcessor());
        EXPORT_ENABLED_FORMATS = new ConfigToken(P_EXPORT_ENABLED_FORMATS, new ExportEnabledFormatProcessor());
        EXPORT_CONTAINER_STYLE = new ConfigToken(P_EXPORT_CONTAINER_STYLE, new StringProcessor());
        EXPORT_CONTAINER_CLASS = new ConfigToken(P_EXPORT_CONTAINER_CLASS, new StringProcessor());
        EXPORT_CLASS = new ConfigToken("export\\.(.*?)\\.class", new ExportFormatProcessor());
        EXPORT_LABEL = new ConfigToken("export\\.(.*?)\\.label", new ExportFormatProcessor());
        EXPORT_FILENAME = new ConfigToken("export\\.(.*?)\\.fileName", new ExportFormatProcessor());
        EXPORT_MIMETYPE = new ConfigToken("export\\.(.*?)\\.mimeType", new ExportFormatProcessor());
        I18N_MSG_PROCESSING = new ConfigToken(P_I18N_MSG_PROCESSING, new MessageProcessor());
        I18N_MSG_SEARCH = new ConfigToken(P_I18N_MSG_SEARCH, new MessageProcessor());
        I18N_MSG_LENGTHMENU = new ConfigToken(P_I18N_MSG_LENGTHMENU, new MessageProcessor());
        I18N_MSG_INFO = new ConfigToken(P_I18N_MSG_INFO, new MessageProcessor());
        I18N_MSG_INFOEMPTY = new ConfigToken(P_I18N_MSG_INFOEMPTY, new MessageProcessor());
        I18N_MSG_INFOFILTERED = new ConfigToken(P_I18N_MSG_INFOFILTERED, new MessageProcessor());
        I18N_MSG_INFOPOSTFIX = new ConfigToken(P_I18N_MSG_INFOPOSTFIX, new MessageProcessor());
        I18N_MSG_LOADINGRECORDS = new ConfigToken(P_I18N_MSG_LOADINGRECORDS, new MessageProcessor());
        I18N_MSG_ZERORECORDS = new ConfigToken(P_I18N_MSG_ZERORECORDS, new MessageProcessor());
        I18N_MSG_EMPTYTABLE = new ConfigToken(P_I18N_MSG_EMPTYTABLE, new MessageProcessor());
        I18N_MSG_PAGINATE_FIRST = new ConfigToken(P_I18N_MSG_PAGINATE_FIRST, new MessageProcessor());
        I18N_MSG_PAGINATE_PREVIOUS = new ConfigToken(P_I18N_MSG_PAGINATE_PREVIOUS, new MessageProcessor());
        I18N_MSG_PAGINATE_NEXT = new ConfigToken(P_I18N_MSG_PAGINATE_NEXT, new MessageProcessor());
        I18N_MSG_PAGINATE_LAST = new ConfigToken(P_I18N_MSG_PAGINATE_LAST, new MessageProcessor());
        I18N_MSG_ARIA_SORTASC = new ConfigToken(P_I18N_MSG_ARIA_SORTASC, new MessageProcessor());
        I18N_MSG_ARIA_SORTDESC = new ConfigToken(P_I18N_MSG_ARIA_SORTDESC, new MessageProcessor());
        INTERNAL_OBJECTTYPE = new ConfigToken("internal.objectType", new StringProcessor());
        internalConf = new HashMap();
        internalConf.put(P_MAIN_EXTENSION_PACKAGE, MAIN_EXTENSION_PACKAGE);
        internalConf.put(P_MAIN_EXTENSION_NAMES, MAIN_EXTENSION_NAMES);
        internalConf.put(TableConfig.formalize(P_CSS_CLASS), CSS_CLASS);
        internalConf.put(TableConfig.formalize(P_CSS_STYLE), CSS_STYLE);
        internalConf.put(TableConfig.formalize(P_CSS_STRIPECLASSES), CSS_STRIPECLASSES);
        internalConf.put(TableConfig.formalize(P_CSS_THEME), CSS_THEME);
        internalConf.put(TableConfig.formalize(P_CSS_THEMEOPTION), CSS_THEMEOPTION);
        internalConf.put(TableConfig.formalize(P_FEATURE_INFO), FEATURE_INFO);
        internalConf.put(TableConfig.formalize(P_FEATURE_AUTOWIDTH), FEATURE_AUTOWIDTH);
        internalConf.put(TableConfig.formalize(P_FEATURE_FILTERABLE), FEATURE_FILTERABLE);
        internalConf.put(TableConfig.formalize(P_FEATURE_FILTER_PLACEHOLDER), FEATURE_FILTER_PLACEHOLDER);
        internalConf.put(TableConfig.formalize(P_FEATURE_FILTER_DELAY), FEATURE_FILTER_DELAY);
        internalConf.put(TableConfig.formalize(P_FEATURE_FILTER_SELECTOR), FEATURE_FILTER_SELECTOR);
        internalConf.put(TableConfig.formalize(P_FEATURE_FILTER_CLEAR_SELECTOR), FEATURE_FILTER_CLEAR_SELECTOR);
        internalConf.put(TableConfig.formalize(P_FEATURE_FILTER_TRIGGER), FEATURE_FILTER_TRIGGER);
        internalConf.put(TableConfig.formalize(P_FEATURE_PAGEABLE), FEATURE_PAGEABLE);
        internalConf.put(TableConfig.formalize(P_FEATURE_PAGINATIONTYPE), FEATURE_PAGINATIONTYPE);
        internalConf.put(TableConfig.formalize(P_FEATURE_LENGTHCHANGE), FEATURE_LENGTHCHANGE);
        internalConf.put(TableConfig.formalize(P_FEATURE_SORTABLE), FEATURE_SORTABLE);
        internalConf.put(TableConfig.formalize(P_FEATURE_STATESAVE), FEATURE_STATESAVE);
        internalConf.put(TableConfig.formalize(P_FEATURE_JQUERYUI), FEATURE_JQUERYUI);
        internalConf.put(TableConfig.formalize(P_FEATURE_LENGTHMENU), FEATURE_LENGTHMENU);
        internalConf.put(TableConfig.formalize(P_FEATURE_DISPLAYLENGTH), FEATURE_DISPLAYLENGTH);
        internalConf.put(TableConfig.formalize(P_FEATURE_DOM), FEATURE_DOM);
        internalConf.put(TableConfig.formalize(P_FEATURE_SCROLLY), FEATURE_SCROLLY);
        internalConf.put(TableConfig.formalize(P_FEATURE_SCROLLCOLLAPSE), FEATURE_SCROLLCOLLAPSE);
        internalConf.put(TableConfig.formalize(P_FEATURE_SCROLLX), FEATURE_SCROLLX);
        internalConf.put(TableConfig.formalize(P_FEATURE_SCROLLXINNER), FEATURE_SCROLLXINNER);
        internalConf.put(TableConfig.formalize(P_FEATURE_APPEAR), FEATURE_APPEAR);
        internalConf.put(TableConfig.formalize(P_FEATURE_APPEAR_DURATION), FEATURE_APPEAR_DURATION);
        internalConf.put(TableConfig.formalize(P_FEATURE_PROCESSING), FEATURE_PROCESSING);
        internalConf.put(TableConfig.formalize(P_AJAX_DEFERRENDER), AJAX_DEFERRENDER);
        internalConf.put(TableConfig.formalize(P_AJAX_SERVERSIDE), AJAX_SERVERSIDE);
        internalConf.put(TableConfig.formalize(P_AJAX_SOURCE), AJAX_SOURCE);
        internalConf.put(TableConfig.formalize(P_AJAX_PIPELINING), AJAX_PIPELINING);
        internalConf.put(TableConfig.formalize(P_AJAX_PIPESIZE), AJAX_PIPESIZE);
        internalConf.put(TableConfig.formalize(P_AJAX_SERVERDATA), AJAX_SERVERDATA);
        internalConf.put(TableConfig.formalize(P_AJAX_SERVERPARAM), AJAX_SERVERPARAM);
        internalConf.put(TableConfig.formalize(P_AJAX_SERVERMETHOD), AJAX_SERVERMETHOD);
        internalConf.put(TableConfig.formalize(P_AJAX_RELOAD_SELECTOR), AJAX_RELOAD_SELECTOR);
        internalConf.put(TableConfig.formalize(P_AJAX_RELOAD_FUNCTION), AJAX_RELOAD_FUNCTION);
        internalConf.put(TableConfig.formalize(P_PLUGIN_FIXEDPOSITION), PLUGIN_FIXEDPOSITION);
        internalConf.put(TableConfig.formalize(P_PLUGIN_FIXEDOFFSETTOP), PLUGIN_FIXEDOFFSETTOP);
        internalConf.put(TableConfig.formalize(P_EXPORT_ENABLED_FORMATS), EXPORT_ENABLED_FORMATS);
        internalConf.put(TableConfig.formalize(P_EXPORT_CONTAINER_STYLE), EXPORT_CONTAINER_STYLE);
        internalConf.put(TableConfig.formalize(P_EXPORT_CONTAINER_CLASS), EXPORT_CONTAINER_CLASS);
        internalConf.put(TableConfig.formalize("export\\.(.*?)\\.class"), EXPORT_CLASS);
        internalConf.put(TableConfig.formalize("export\\.(.*?)\\.label"), EXPORT_LABEL);
        internalConf.put(TableConfig.formalize("export\\.(.*?)\\.fileName"), EXPORT_FILENAME);
        internalConf.put(TableConfig.formalize("export\\.(.*?)\\.mimeType"), EXPORT_MIMETYPE);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_PROCESSING), I18N_MSG_PROCESSING);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_SEARCH), I18N_MSG_SEARCH);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_LENGTHMENU), I18N_MSG_LENGTHMENU);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_INFO), I18N_MSG_INFO);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_INFOEMPTY), I18N_MSG_INFOEMPTY);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_INFOFILTERED), I18N_MSG_INFOFILTERED);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_INFOPOSTFIX), I18N_MSG_INFOPOSTFIX);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_LOADINGRECORDS), I18N_MSG_LOADINGRECORDS);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_ZERORECORDS), I18N_MSG_ZERORECORDS);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_EMPTYTABLE), I18N_MSG_EMPTYTABLE);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_PAGINATE_FIRST), I18N_MSG_PAGINATE_FIRST);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_PAGINATE_PREVIOUS), I18N_MSG_PAGINATE_PREVIOUS);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_PAGINATE_NEXT), I18N_MSG_PAGINATE_NEXT);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_PAGINATE_LAST), I18N_MSG_PAGINATE_LAST);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_ARIA_SORTASC), I18N_MSG_ARIA_SORTASC);
        internalConf.put(TableConfig.formalize(P_I18N_MSG_ARIA_SORTDESC), I18N_MSG_ARIA_SORTDESC);
    }
}

