/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.configuration;

import com.github.dandelion.core.utils.LibraryDetector;
import com.github.dandelion.core.utils.PropertiesUtils;
import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.core.utils.UTF8Control;
import com.github.dandelion.core.web.AssetRequestContext;
import com.github.dandelion.datatables.core.configuration.ConfigToken;
import com.github.dandelion.datatables.core.configuration.ConfigurationLoader;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.exception.ConfigurationLoadingException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardConfigurationLoader
implements ConfigurationLoader {
    private static Logger logger = LoggerFactory.getLogger(StandardConfigurationLoader.class);
    protected static Properties defaultProperties;
    private Properties userProperties;
    private Set<String> groups;

    @Override
    public Properties loadDefaultConfiguration() {
        if (defaultProperties == null) {
            logger.debug("Loading default configuration...");
            Properties propertiesResource = new Properties();
            InputStream propertiesStream = null;
            try {
                propertiesStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/datatables-default.properties");
                InputStreamReader reader = new InputStreamReader(propertiesStream, "UTF-8");
                propertiesResource.load(reader);
            }
            catch (IOException e) {
                throw new ConfigurationLoadingException("Unable to load the default configuration file", e);
            }
            finally {
                if (propertiesStream != null) {
                    try {
                        propertiesStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            defaultProperties = propertiesResource;
            logger.debug("Default configuration loaded");
        }
        return defaultProperties;
    }

    @Override
    public Properties loadUserConfiguration(Locale locale) {
        ResourceBundle.clearCache();
        ResourceBundle userBundle = null;
        if (StringUtils.isNotBlank((String)System.getProperty("dandelion.datatables.configuration"))) {
            String path = System.getProperty("dandelion.datatables.configuration");
            try {
                URL resourceURL = new File(path).toURI().toURL();
                URLClassLoader urlLoader = new URLClassLoader(new URL[]{resourceURL});
                userBundle = ResourceBundle.getBundle("datatables", locale, urlLoader, (ResourceBundle.Control)new UTF8Control());
            }
            catch (MalformedURLException e) {
                logger.warn("Wrong path to the externalized bundle", (Throwable)e);
            }
            catch (MissingResourceException e) {
                logger.info("No *.properties file in {}. Trying to lookup in classpath...", (Object)path);
            }
        }
        if (userBundle == null) {
            try {
                userBundle = ResourceBundle.getBundle("dandelion/datatables/datatables", locale, (ResourceBundle.Control)new UTF8Control());
            }
            catch (MissingResourceException e) {
                try {
                    userBundle = ResourceBundle.getBundle("dandelion/datatables/datatables", locale, Thread.currentThread().getContextClassLoader(), (ResourceBundle.Control)new UTF8Control());
                }
                catch (MissingResourceException mre) {
                    logger.debug("No custom configuration. Using default one.");
                }
            }
        }
        this.userProperties = PropertiesUtils.bundleToProperties(userBundle);
        return this.userProperties;
    }

    @Override
    public Set<String> resolveGroups(Locale locale) {
        logger.debug("Resolving groups for the locale {}...", (Object)locale);
        HashSet<String> groups = new HashSet<String>();
        if (this.userProperties != null && !this.userProperties.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.userProperties.entrySet()) {
                String key = entry.getKey().toString();
                if (key.contains("i18n.locale.resolver") || key.contains("i18n.message.resolver") || key.contains("main.standalone")) continue;
                groups.add(key.substring(0, key.indexOf(".")));
            }
        }
        groups.add("global");
        logger.debug("{} groups declared {}.", (Object)groups.size(), (Object)((Object)groups).toString());
        this.groups = groups;
        return this.groups;
    }

    @Override
    public void resolveConfigurations(Map<String, Map<ConfigToken<?>, Object>> map, Locale locale, HttpServletRequest request) {
        String key;
        logger.debug("Resolving configurations for the locale {}...", (Object)locale);
        this.loadAutoConfiguration(this.userProperties);
        Properties globalProperties = new Properties();
        for (Map.Entry<Object, Object> entry : defaultProperties.entrySet()) {
            key = entry.getKey().toString();
            if (key.equals("i18n.locale.resolver") || key.equals("i18n.message.resolver") || key.equals("main.standalone")) continue;
            globalProperties.put(key.substring(key.indexOf(".") + 1), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.userProperties.entrySet()) {
            key = entry.getKey().toString();
            if (!key.startsWith("global")) continue;
            globalProperties.put(key.substring(key.indexOf(".") + 1), entry.getValue());
        }
        if (this.userProperties.containsKey("main.standalone") && this.userProperties.getProperty("main.standalone").equals("true")) {
            AssetRequestContext.get((ServletRequest)request).excludeBundles("bootstrap-datepicker,bootstrap2,bootstrap3,jquery,jqueryui,moment");
        }
        HashMap userConf = null;
        HashMap wrongKeys = new HashMap();
        for (String groupName : this.groups) {
            String key2;
            Properties groupedProperties = new Properties();
            groupedProperties.putAll((Map<?, ?>)globalProperties);
            for (Map.Entry<Object, Object> entry : this.userProperties.entrySet()) {
                key2 = entry.getKey().toString();
                if (!key2.startsWith(groupName)) continue;
                groupedProperties.put(key2.substring(key2.indexOf(".") + 1), entry.getValue());
            }
            logger.debug("Group '{}' initialized with {} properties", (Object)groupName, (Object)groupedProperties.size());
            userConf = new HashMap();
            for (Map.Entry<Object, Object> entry : groupedProperties.entrySet()) {
                key2 = entry.getKey().toString().trim().toLowerCase();
                ConfigToken<?> configToken = TableConfig.findByPropertyName(key2);
                if (configToken != null) {
                    userConf.put(configToken, entry.getValue().toString());
                    continue;
                }
                if (key2.equals("i18n.locale.resolver") || key2.equals("i18n.message.resolver")) continue;
                if (wrongKeys.containsKey(groupName)) {
                    ((List)wrongKeys.get(groupName)).add(key2);
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                values.add(key2);
                wrongKeys.put(groupName, values);
            }
            map.put(groupName, userConf);
        }
        if (!wrongKeys.isEmpty()) {
            StringBuilder msg = new StringBuilder("Some properties of your configuration file are not recognized.\n");
            for (Map.Entry entry : wrongKeys.entrySet()) {
                msg.append("The group '");
                msg.append((String)entry.getKey());
                msg.append("' contains ");
                msg.append(((List)entry.getValue()).size());
                msg.append(" unknown propert");
                msg.append(((List)entry.getValue()).size() > 1 ? "ies:\n" : "y:\n");
                for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                    msg.append((String)((List)entry.getValue()).get(i));
                    if (i >= ((List)entry.getValue()).size() - 1) continue;
                    msg.append("\n");
                }
                msg.append("\n");
            }
            logger.error(msg.toString());
            throw new ConfigurationLoadingException(msg.toString());
        }
        logger.debug("{} group(s) resolved {} for the locale {}", new Object[]{this.groups.size(), this.groups.toString(), locale});
    }

    private void loadAutoConfiguration(Properties userProps) {
        if (LibraryDetector.isJstlAvailable() && !LibraryDetector.isThymeleafAvailable() && userProps != null) {
            if (!userProps.isEmpty()) {
                for (Map.Entry<Object, Object> entry : userProps.entrySet()) {
                    String key = entry.getKey().toString();
                    if (!key.contains("i18n.message.resolver") || !StringUtils.isBlank((String)entry.getValue().toString())) continue;
                    userProps.put(entry.getKey(), "com.github.dandelion.datatables.jsp.i18n.JstlMessageResolver");
                }
            } else {
                userProps.put("global.i18n.message.resolver", "com.github.dandelion.datatables.jsp.i18n.JstlMessageResolver");
            }
        }
    }
}

