/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.asset;

import com.github.dandelion.core.utils.StringUtils;

public class JavascriptFunction {
    private String code;
    private boolean hasReturn;
    private String[] args;

    public JavascriptFunction(String code) {
        this.code = code;
        this.hasReturn = false;
        this.args = null;
    }

    public JavascriptFunction(String code, boolean hasReturn) {
        this.code = code;
        this.hasReturn = hasReturn;
        this.args = null;
    }

    public JavascriptFunction(String code, String ... args) {
        this.code = code;
        this.args = args;
    }

    public JavascriptFunction(String code, boolean hasReturn, String ... args) {
        this.code = code;
        this.hasReturn = hasReturn;
        this.args = args;
    }

    public String toString() {
        StringBuilder js = new StringBuilder();
        js.append("function(");
        js.append(this.args != null ? StringUtils.join((Object[])this.args, (String)",") : "");
        js.append(") {").append('\n').append("   ").append("   ");
        js.append(this.hasReturn ? "return " : "");
        js.append(this.code).append('\n').append("   ");
        js.append("}");
        return js.toString();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void appendCode(String code) {
        this.code = this.code + code;
    }

    public void appendCode(char character) {
        this.code = this.code + character;
    }

    public boolean equals(Object javascriptFunction) {
        if (javascriptFunction != null && javascriptFunction instanceof JavascriptFunction) {
            JavascriptFunction castedJavascriptFunction = (JavascriptFunction)javascriptFunction;
            return this.toString().equals(castedJavascriptFunction.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

