/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.web;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.web.HttpHeader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;

public class HttpHeadersConfigurer {
    public static final long ONE_YEAR_IN_MILLISECONDS = 31536000000L;
    public static final String DEFAULT_CACHE_CONTROL = "public, max-age=315360000";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.US);
    private Context context;

    public HttpHeadersConfigurer(Context context) {
        this.context = context;
    }

    public void configureResponseHeaders(HttpServletResponse response, String contentType) {
        response.setContentType(contentType == null ? "text/plain" : contentType);
        if (this.context.isDevModeEnabled()) {
            response.setHeader(HttpHeader.CACHE_CONTROL.getName(), "no-cache, no-store, must-revalidate");
            response.setHeader(HttpHeader.PRAGMA.getName(), "no-cache");
            response.setHeader(HttpHeader.EXPIRES.getName(), String.valueOf(0));
        } else {
            response.setHeader(HttpHeader.CACHE_CONTROL.getName(), DEFAULT_CACHE_CONTROL);
            response.setHeader(HttpHeader.EXPIRES.getName(), String.valueOf(31536000000L));
            long lastModified = new Date().getTime();
            lastModified = TimeUnit.MILLISECONDS.toSeconds(lastModified);
            lastModified = TimeUnit.SECONDS.toMillis(lastModified);
            response.setHeader(HttpHeader.LAST_MODIFIED.getName(), DATE_FORMAT.format(lastModified));
        }
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

