/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.web;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.asset.AssetType;
import com.github.dandelion.core.web.HttpHeadersConfigurer;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DandelionServlet
extends HttpServlet {
    private static final long serialVersionUID = -6874842638265359418L;
    private static Logger LOG = LoggerFactory.getLogger(DandelionServlet.class);
    public static final String DANDELION_ASSETS = "dandelionAssets";
    public static final String DANDELION_ASSETS_URL = "/dandelion-assets/";
    public static final String DANDELION_ASSETS_URL_PATTERN = "/dandelion-assets/*";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getLogger().debug("Dandelion Asset servlet captured GET request {}", (Object)request.getRequestURI());
        Context context = (Context)request.getAttribute("dandelionContext");
        HttpHeadersConfigurer httpHeadersConfigurer = new HttpHeadersConfigurer(context);
        String assetKey = context.getCacheManager().getCacheKeyFromRequest(request);
        AssetType assetType = AssetType.typeOfAsset(assetKey);
        httpHeadersConfigurer.configureResponseHeaders(response, assetType.getContentType());
        PrintWriter writer = response.getWriter();
        writer.write(context.getCacheManager().getContent(assetKey));
        writer.close();
    }

    protected Logger getLogger() {
        return LOG;
    }
}

