/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.web;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.asset.Asset;
import com.github.dandelion.core.asset.AssetDomPosition;
import com.github.dandelion.core.asset.AssetQuery;
import com.github.dandelion.core.html.HtmlTag;
import com.github.dandelion.core.monitoring.GraphViewer;
import com.github.dandelion.core.utils.HtmlUtils;
import com.github.dandelion.core.web.ByteArrayResponseWrapper;
import java.io.IOException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DandelionFilter
implements Filter {
    private static Logger LOG = LoggerFactory.getLogger(DandelionFilter.class);
    private Context context;

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("Initializing the Dandelion context");
        this.context = new Context(filterConfig);
        LOG.info("Dandelion context initialized");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse serlvetResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            LOG.warn("The AssetFilter only applies to HTTP requests");
            filterChain.doFilter(servletRequest, serlvetResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)serlvetResponse;
        request.setAttribute("dandelionContext", (Object)this.context);
        if (this.context.isDevModeEnabled() && request.getParameter("reloadBundles") != null) {
            LOG.info("Bundle reloading requested via request parameter");
            this.context.initBundleStorage();
            LOG.info("Bundle reloaded");
        }
        ByteArrayResponseWrapper wrappedResponse = new ByteArrayResponseWrapper(response);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse);
        if (this.context.isDevModeEnabled() && request.getParameter("showGraph") != null) {
            GraphViewer graphViewer = new GraphViewer(this.context);
            response.getWriter().print(graphViewer.getView(request, response, filterChain));
            return;
        }
        byte[] bytes = wrappedResponse.toByteArray();
        if (this.isRelevant(request, wrappedResponse)) {
            Set<Asset> assetsBody;
            String html = new String(bytes);
            Set<Asset> assetsHead = new AssetQuery(request, this.context).withPosition(AssetDomPosition.head).perform();
            if (!assetsHead.isEmpty()) {
                StringBuilder htmlHead = new StringBuilder();
                for (Asset asset : assetsHead) {
                    HtmlTag tag = HtmlUtils.transformAsset(asset);
                    htmlHead.append(tag.toHtml());
                    htmlHead.append('\n');
                }
                html = html.replace("</head>", htmlHead + "\n</head>");
            }
            if (!(assetsBody = new AssetQuery(request, this.context).withPosition(AssetDomPosition.body).perform()).isEmpty()) {
                StringBuilder htmlBody = new StringBuilder();
                for (Asset asset : assetsBody) {
                    HtmlTag tag = HtmlUtils.transformAsset(asset);
                    htmlBody.append(tag.toHtml());
                    htmlBody.append('\n');
                }
                html = html.replace("</body>", htmlBody + "</body>");
            }
            response.getWriter().print(html);
        } else {
            response.getOutputStream().write(bytes);
        }
    }

    public boolean isRelevant(HttpServletRequest request, ByteArrayResponseWrapper wrappedResponse) {
        boolean dandelionFilterApplyable = true;
        if (wrappedResponse.getContentType() == null || !wrappedResponse.getContentType().contains("text/html")) {
            dandelionFilterApplyable = false;
        }
        if (request.getAttribute("dandelionAssetFilterState") != null) {
            boolean bl = dandelionFilterApplyable = dandelionFilterApplyable && Boolean.parseBoolean(String.valueOf(request.getAttribute("dandelionAssetFilterState")));
            if (!dandelionFilterApplyable) {
                LOG.debug("DandelionFilter explicitely disabled by the {} attribute for the request '{}'", (Object)"dandelionAssetFilterState", (Object)request.getRequestURI());
            }
        } else if (request.getParameter("dandelionAssetFilterState") != null) {
            boolean bl = dandelionFilterApplyable = dandelionFilterApplyable && Boolean.parseBoolean(String.valueOf(request.getParameter("dandelionAssetFilterState")));
            if (!dandelionFilterApplyable) {
                LOG.debug("DandelionFilter explicitely disabled by the {} parameter for the request '{}'", (Object)"dandelionAssetFilterState", (Object)request.getRequestURI());
            }
        }
        return dandelionFilterApplyable;
    }

    public void destroy() {
        this.context.destroy();
    }
}

