/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.web;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;

public class AssetRequestContext {
    private List<String> bundles = new ArrayList<String>();
    private List<String> excludedBundles = new ArrayList<String>();
    private List<String> excludedJs = new ArrayList<String>();
    private List<String> excludedCss = new ArrayList<String>();
    private Map<String, Map<String, Object>> parameters = new HashMap<String, Map<String, Object>>();

    private AssetRequestContext() {
    }

    public static AssetRequestContext get(ServletRequest servletRequest) {
        Object attribute = servletRequest.getAttribute(AssetRequestContext.class.getCanonicalName());
        Context context = (Context)servletRequest.getAttribute("dandelionContext");
        if (attribute == null || !(attribute instanceof AssetRequestContext)) {
            attribute = new AssetRequestContext();
            ((AssetRequestContext)attribute).addBundles(context.getConfiguration().getBundleIncludes());
            ((AssetRequestContext)attribute).excludeBundles(context.getConfiguration().getBundleExcludes());
            ((AssetRequestContext)attribute).excludeJs(context.getConfiguration().getAssetJsExcludes());
            ((AssetRequestContext)attribute).excludeCss(context.getConfiguration().getAssetCssExcludes());
            servletRequest.setAttribute(AssetRequestContext.class.getCanonicalName(), attribute);
        }
        return (AssetRequestContext)AssetRequestContext.class.cast(attribute);
    }

    public AssetRequestContext addBundles(String bundles) {
        if (bundles == null || bundles.isEmpty()) {
            return this;
        }
        return this.addBundles(bundles.split(","));
    }

    public AssetRequestContext addBundles(String ... bundles) {
        this.bundles.addAll(Arrays.asList(bundles));
        return this;
    }

    public AssetRequestContext addBundles(Collection<String> bundles) {
        for (String bundle : bundles) {
            this.addBundle(bundle);
        }
        return this;
    }

    public AssetRequestContext addBundles(Enum<?> ... bundles) {
        for (Enum<?> bundle : bundles) {
            this.addBundle(bundle);
        }
        return this;
    }

    public AssetRequestContext addBundle(String bundle) {
        this.bundles.add(bundle.trim());
        return this;
    }

    public AssetRequestContext addBundle(Enum<?> bundle) {
        this.addBundle(bundle.toString().toLowerCase().replace("_", "-"));
        return this;
    }

    public String[] getBundles(boolean withoutExcludedBundles) {
        ArrayList<String> bundles = new ArrayList<String>(this.bundles);
        if (withoutExcludedBundles) {
            bundles.removeAll(this.excludedBundles);
        }
        return bundles.toArray(new String[bundles.size()]);
    }

    public AssetRequestContext excludeBundles(String bundles) {
        if (bundles == null || bundles.isEmpty()) {
            return this;
        }
        return this.excludeBundles(bundles.split(","));
    }

    public AssetRequestContext excludeBundles(Collection<String> bundles) {
        for (String bundle : bundles) {
            this.excludeBundles(bundle);
        }
        return this;
    }

    private AssetRequestContext excludeBundles(String ... bundles) {
        this.excludedBundles.addAll(Arrays.asList(bundles));
        return this;
    }

    public AssetRequestContext excludeJs(String jsNames) {
        if (StringUtils.isNotBlank(jsNames)) {
            return this.excludeJs(jsNames.split(","));
        }
        return this;
    }

    public AssetRequestContext excludeJs(Collection<String> jsToExclude) {
        for (String js : jsToExclude) {
            this.excludeJs(js);
        }
        return this;
    }

    public AssetRequestContext excludeCss(String cssNames) {
        if (StringUtils.isNotBlank(cssNames)) {
            return this.excludeCss(cssNames.split(","));
        }
        return this;
    }

    public AssetRequestContext excludeCss(Collection<String> cssToExclude) {
        for (String css : cssToExclude) {
            this.excludeCss(css);
        }
        return this;
    }

    private AssetRequestContext excludeJs(String ... jsNames) {
        for (String jsName : jsNames) {
            this.excludedJs.add(jsName.trim().toLowerCase());
        }
        return this;
    }

    private AssetRequestContext excludeCss(String ... cssNames) {
        for (String cssName : cssNames) {
            this.excludedCss.add(cssName.trim().toLowerCase());
        }
        return this;
    }

    public String[] getExcludedBundles() {
        return this.excludedBundles.toArray(new String[this.excludedBundles.size()]);
    }

    public String[] getExcludedJs() {
        return this.excludedJs.toArray(new String[this.excludedJs.size()]);
    }

    public String[] getExcludedCss() {
        return this.excludedCss.toArray(new String[this.excludedCss.size()]);
    }

    public AssetRequestContext addParameter(String assetName, String parameter, Object value) {
        return this.addParameter(assetName, parameter, value, false);
    }

    public AssetRequestContext addParameter(Object assetName, String parameter, Object value) {
        return this.addParameter(assetName.toString(), parameter, value, false);
    }

    public AssetRequestContext addParameter(String assetName, String parameter, Object value, boolean replaceIfExists) {
        if (!this.parameters.containsKey(assetName)) {
            this.parameters.put(assetName, new HashMap());
        }
        if (!this.parameters.get(assetName).containsKey(parameter)) {
            this.parameters.get(assetName).put(parameter, value);
        } else if (replaceIfExists) {
            this.parameters.get(assetName).put(parameter, value);
        }
        return this;
    }

    public AssetRequestContext addParameter(Object assetName, String parameter, Object value, boolean replaceIfExists) {
        return this.addParameter(assetName.toString(), parameter, value, replaceIfExists);
    }

    public Map<String, Object> getParameters(String assetName) {
        if (!this.parameters.containsKey(assetName)) {
            return Collections.emptyMap();
        }
        return this.parameters.get(assetName);
    }

    public Map<String, Object> getParameters(Object assetName) {
        return this.getParameters(assetName.toString());
    }

    public <T> T getParameterValue(String assetName, String parameter) {
        Map<String, Object> values = this.getParameters(assetName);
        if (!values.containsKey(parameter)) {
            return null;
        }
        return (T)values.get(parameter);
    }

    public <T> T getParameterValue(Object assetName, String parameter) {
        return this.getParameterValue(assetName.toString(), parameter);
    }
}

