/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UrlUtils {
    private static final String FORWARD_REQUEST_URI_ATTRIBUTE = "javax.servlet.forward.request_uri";
    private static final String FORWARD_QUERY_STRING_ATTRIBUTE = "javax.servlet.forward.query_string";
    private static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";

    public static StringBuilder getCurrentUri(HttpServletRequest request) {
        StringBuilder currentUri = new StringBuilder();
        if (request.getAttribute(FORWARD_REQUEST_URI_ATTRIBUTE) != null) {
            currentUri.append(request.getAttribute(FORWARD_REQUEST_URI_ATTRIBUTE));
        } else if (request.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null) {
            currentUri.append(request.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE));
        } else {
            currentUri.append(request.getRequestURI());
        }
        if (request.getAttribute(FORWARD_QUERY_STRING_ATTRIBUTE) != null) {
            currentUri.append("?").append(request.getAttribute(FORWARD_QUERY_STRING_ATTRIBUTE));
        } else if (request.getQueryString() != null) {
            currentUri.append("?").append(request.getQueryString());
        }
        return currentUri;
    }

    public static StringBuilder getCurrentUrl(HttpServletRequest request, boolean preserveParameters) {
        StringBuilder currentUrl = new StringBuilder(request.getRequestURL());
        if (preserveParameters) {
            if (request.getAttribute(FORWARD_QUERY_STRING_ATTRIBUTE) != null) {
                currentUrl.append("?").append(request.getAttribute(FORWARD_QUERY_STRING_ATTRIBUTE));
            } else if (request.getQueryString() != null) {
                currentUrl.append("?").append(request.getQueryString());
            }
        }
        return currentUrl;
    }

    public static String getProcessedUrl(String url, HttpServletRequest request, HttpServletResponse response) {
        String processedUrl = null;
        processedUrl = UrlUtils.isContextRelative(url, request) && !url.startsWith(request.getContextPath()) ? request.getContextPath() + url : (UrlUtils.isServerRelative(url) ? url.substring(1) : (UrlUtils.isAbsolute(url) ? url : url));
        return response != null ? response.encodeURL(processedUrl) : processedUrl;
    }

    public static String getProcessedUrl(StringBuilder url, HttpServletRequest request, HttpServletResponse response) {
        return UrlUtils.getProcessedUrl(url.toString(), request, response);
    }

    public static boolean isAbsolute(String url) {
        return url.contains("://") || url.toLowerCase().startsWith("mailto:") || url.startsWith("//");
    }

    public static boolean isContextRelative(String url, HttpServletRequest request) {
        return url.startsWith("/") && !url.startsWith("//");
    }

    public static boolean isServerRelative(String url) {
        return url.startsWith("~/");
    }

    public static boolean isProtocolRelative(String url) {
        return url.startsWith("//");
    }

    public static StringBuilder getContext(HttpServletRequest request) {
        return new StringBuilder(request.getContextPath());
    }

    public static void addParameter(StringBuilder url, String name, Object value) {
        if (url.indexOf("?") == -1) {
            url.append("?");
        } else {
            url.append("&");
        }
        try {
            url.append(name).append("=").append(URLEncoder.encode(String.valueOf(value), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static String getBaseUrl(HttpServletRequest request) {
        return UrlUtils.getBaseUrl(request, true);
    }

    public static String getBaseUrl(HttpServletRequest request, boolean withContextPath) {
        if (request.getRequestURI().equals("/") || request.getRequestURI().equals("")) {
            return request.getRequestURL().toString();
        }
        if (withContextPath) {
            return request.getRequestURL().toString().replace(request.getRequestURI(), request.getContextPath());
        }
        return request.getRequestURL().toString().replace(request.getRequestURI(), "");
    }
}

