/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.utils;

import java.util.Iterator;

public class StringUtils {
    private static final String[] ESCAPES;

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String capitalize(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(str.toString());
        if (result.length() > 0) {
            result.setCharAt(0, Character.toTitleCase(result.charAt(0)));
        }
        return result.toString();
    }

    public static String uncapitalize(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(str);
        if (result.length() > 0) {
            result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        }
        return result.toString();
    }

    public static String join(Object[] target, String separator) {
        StringBuilder sb = new StringBuilder();
        if (target.length > 0) {
            sb.append(target[0]);
            for (int i = 1; i < target.length; ++i) {
                sb.append(separator);
                sb.append(target[i]);
            }
        }
        return sb.toString();
    }

    public static String join(Iterable<?> target, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = target.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(separator);
                sb.append(it.next());
            }
        }
        return sb.toString();
    }

    public static boolean containsAny(String str, char[] searchChars) {
        int csLength = str.length();
        int searchLength = searchChars.length;
        for (int i = 0; i < csLength; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < searchLength; ++j) {
                if (searchChars[j] != ch) continue;
                return true;
            }
        }
        return false;
    }

    public static String trimAllWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        int index = 0;
        while (sb.length() > index) {
            if (Character.isWhitespace(sb.charAt(index))) {
                sb.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return sb.toString();
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((CharSequence)str);
    }

    public static String escape(String src) {
        if (src == null) {
            return src;
        }
        int length = 0;
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            String escape = StringUtils.getEscape(c);
            if (escape != null) {
                length += escape.length();
                continue;
            }
            ++length;
        }
        if (length == src.length()) {
            return src;
        }
        StringBuilder buf = new StringBuilder(length);
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            String escape = StringUtils.getEscape(c);
            if (escape != null) {
                buf.append(escape);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String escape(boolean shouldEscape, String src) {
        if (shouldEscape) {
            return StringUtils.escape(src);
        }
        return src;
    }

    private static String getEscape(char c) {
        if (c < ESCAPES.length) {
            return ESCAPES[c];
        }
        return null;
    }

    public static int countMatches(CharSequence str, CharSequence sub) {
        if (str == null || str.length() == 0 || sub == null || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = StringUtils.indexOf(str, sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static int indexOf(CharSequence cs, CharSequence searchChar, int start) {
        return ((Object)cs).toString().indexOf(((Object)searchChar).toString(), start);
    }

    static {
        int size = 63;
        ESCAPES = new String[size];
        StringUtils.ESCAPES[60] = "&lt;";
        StringUtils.ESCAPES[62] = "&gt;";
        StringUtils.ESCAPES[38] = "&amp;";
        StringUtils.ESCAPES[39] = "&#039;";
        StringUtils.ESCAPES[34] = "&#034;";
    }
}

