/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Sha1Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Sha1Utils.class);
    static MessageDigest mDigest;

    public static String generateSha1(String input, boolean neverFail) {
        if (mDigest == null) {
            if (neverFail) {
                LOG.error("SHA-1 can't be calculated for [{}]. Returning the unchanged input instead.", (Object)input);
                return input;
            }
            LOG.error("SHA-1 can't be calculated for [{}]. Returning null instead.", (Object)input);
            return null;
        }
        byte[] result = mDigest.digest(input.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte aResult : result) {
            sb.append(Integer.toString((aResult & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    static {
        try {
            mDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("SHA1 algorithm unknown, no generation");
        }
    }
}

