/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.utils;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.utils.UrlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

public final class ResourceUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static InputStream getFileFromClasspath(String pathToFile) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(pathToFile);
    }

    public static String getFileContentFromClasspath(String pathToFile) {
        return ResourceUtils.getFileContentFromClasspath(pathToFile, true);
    }

    public static String getFileContentFromClasspath(String pathToFile, boolean neverFail) {
        try {
            InputStream in = ResourceUtils.getFileFromClasspath(pathToFile);
            return ResourceUtils.getContentFromInputStream(in);
        }
        catch (IOException e) {
            StringBuilder sb = new StringBuilder("The content pointed by the path ");
            sb.append(pathToFile);
            sb.append(" can't be read from an inputStream.");
            throw new DandelionException(sb.toString(), e);
        }
    }

    public static String getContentFromInputStream(InputStream input) throws IOException {
        int n;
        StringWriter sw = new StringWriter();
        InputStreamReader in = new InputStreamReader(input);
        char[] buffer = new char[4096];
        while (-1 != (n = in.read(buffer))) {
            sw.write(buffer, 0, n);
        }
        return sw.toString();
    }

    public static String getContentFromUrl(HttpServletRequest request, String url, boolean neverFail) {
        try {
            if (UrlUtils.isProtocolRelative(url)) {
                String string = url = request.isSecure() ? "https:" : "http:" + url;
            }
            if (UrlUtils.isContextRelative(url, request)) {
                url = UrlUtils.getBaseUrl(request, false) + url;
            }
            URL urlLocation = new URL(url);
            return ResourceUtils.getContentFromInputStream(urlLocation.openStream());
        }
        catch (IOException e) {
            if (neverFail) {
                return "";
            }
            StringBuilder sb = new StringBuilder("The content pointed by the url ");
            sb.append(url);
            sb.append(" can't be read.");
            throw new DandelionException(sb.toString(), e);
        }
    }

    private ResourceUtils() {
    }
}

