/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.utils;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.utils.PathUtils;
import com.github.dandelion.core.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceScanner.class);

    public static String findResourcePath(String location, String nameFilter) throws IOException {
        Set<String> resourcePaths = ResourceScanner.scanForResourcePaths(location, null, nameFilter, null, null, false);
        if (resourcePaths.isEmpty()) {
            return null;
        }
        return resourcePaths.iterator().next();
    }

    public static Set<String> findResourcePaths(String location, Set<String> excludedPaths, String nameFilter, boolean recursive) throws IOException {
        return ResourceScanner.scanForResourcePaths(location, excludedPaths, nameFilter, null, null, recursive);
    }

    public static Set<String> findResourcePaths(String location, Set<String> excludedPaths, String prefixFilter, String suffixFilter, boolean recursive) throws IOException {
        return ResourceScanner.scanForResourcePaths(location, excludedPaths, null, prefixFilter, suffixFilter, recursive);
    }

    private static Set<String> scanForResourcePaths(String location, Set<String> excludedPaths, String nameFilter, String prefixFilter, String suffixFilter, boolean recursive) throws IOException {
        LOG.trace("Scanning for resources at '{}'...", (Object)location);
        HashSet<String> resourcePaths = new HashSet<String>();
        Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(location);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if ("file".equals(url.getProtocol())) {
                String resourcePath = PathUtils.toFilePath(url);
                String classpathPhysicalRoot = resourcePath.substring(0, resourcePath.length() - location.length());
                File folder = new File(resourcePath);
                resourcePaths.addAll(ResourceScanner.scanForResourcePathsInFileSystem(folder, classpathPhysicalRoot, recursive));
                continue;
            }
            if ("jar".equals(url.getProtocol()) || "zip".equals(url.getProtocol()) || "wsjar".equals(url.getProtocol())) {
                resourcePaths.addAll(ResourceScanner.scanForResourcePathsInJarFile(url));
                continue;
            }
            StringBuilder sb = new StringBuilder("The protocol ");
            sb.append(url.getProtocol());
            sb.append(" is not supported.");
            throw new DandelionException(sb.toString());
        }
        LOG.trace("{} resources found before filtering", (Object)resourcePaths.size());
        return ResourceScanner.filterResourcePaths(location, resourcePaths, excludedPaths, nameFilter, prefixFilter, suffixFilter);
    }

    private static Set<String> scanForResourcePathsInFileSystem(File folder, String classpathPhysicalRoot, boolean recursive) throws IOException {
        HashSet<String> extractedResourcePaths = new HashSet<String>();
        for (File file : folder.listFiles()) {
            if (!file.canRead()) continue;
            if (file.isDirectory() && recursive) {
                extractedResourcePaths.addAll(ResourceScanner.scanForResourcePathsInFileSystem(file, classpathPhysicalRoot, recursive));
                continue;
            }
            String filePath = URLDecoder.decode(file.toURI().toURL().getFile(), "UTF-8");
            String resourcePath = filePath.substring(classpathPhysicalRoot.length());
            extractedResourcePaths.add(resourcePath);
        }
        return extractedResourcePaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> scanForResourcePathsInJarFile(URL url) throws IOException {
        HashSet<String> extractedResourcePaths = new HashSet<String>();
        URLConnection connection = url.openConnection();
        if (connection instanceof JarURLConnection) {
            JarURLConnection jarConnection = (JarURLConnection)connection;
            jarConnection.setUseCaches(false);
            JarFile jarFile = jarConnection.getJarFile();
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String resourcePath = entries.nextElement().getName();
                    extractedResourcePaths.add(resourcePath);
                }
            }
            finally {
                jarFile.close();
            }
        }
        return extractedResourcePaths;
    }

    private static boolean isPathAuthorized(String resourcePath, String authorizedLocation, Set<String> excludedPaths) {
        if (excludedPaths != null) {
            for (String excludedFolder : excludedPaths) {
                if (!resourcePath.startsWith(excludedFolder)) continue;
                return false;
            }
            return true;
        }
        return resourcePath.startsWith(authorizedLocation);
    }

    private static Set<String> filterResourcePaths(String location, Set<String> resourcePaths, Set<String> excludedPaths, String nameFilter, String prefixFilter, String suffixFilter) {
        HashSet<String> filteredResources = new HashSet<String>();
        LOG.debug("Filtering scanned resources");
        for (String resourcePath : resourcePaths) {
            if (!ResourceScanner.isPathAuthorized(resourcePath, location, excludedPaths)) continue;
            String resourceName = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
            if (StringUtils.isBlank(nameFilter) && StringUtils.isBlank(prefixFilter) && StringUtils.isBlank(suffixFilter)) {
                filteredResources.add(resourcePath);
                continue;
            }
            if (StringUtils.isNotBlank(nameFilter)) {
                if (!nameFilter.equalsIgnoreCase(resourceName)) continue;
                filteredResources.add(resourcePath);
                continue;
            }
            if (suffixFilter == null && resourceName.startsWith(prefixFilter)) {
                filteredResources.add(resourcePath);
                continue;
            }
            if (prefixFilter == null && resourceName.endsWith(suffixFilter)) {
                filteredResources.add(resourcePath);
                continue;
            }
            if (prefixFilter == null || suffixFilter == null || !resourceName.startsWith(prefixFilter) || !resourceName.endsWith(suffixFilter)) continue;
            filteredResources.add(resourcePath);
        }
        LOG.debug("{} resources found after filtering", (Object)filteredResources.size());
        return filteredResources;
    }

    private ResourceScanner() {
    }
}

