/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;

public class PropertiesUtils {
    public static List<String> propertyBeginWith(String prefix, Properties properties) {
        ArrayList<String> values = new ArrayList<String>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            values.add(properties.getProperty(key));
        }
        return values;
    }

    public static Properties bundleToProperties(ResourceBundle bundle) {
        Properties properties = new Properties();
        if (bundle != null) {
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                properties.put(key, bundle.getString(key));
            }
        }
        return properties;
    }

    public static List<String> propertyAsList(String values, String delimiter) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(values.split(delimiter));
    }
}

