/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.utils;

import com.github.dandelion.core.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PathUtils {
    public static final String URL_SEPARATOR = "/";
    public static final char URL_SEPARATOR_CHAR = '/';
    public static final String COMMA_SEPARATOR = ",";
    private static final Pattern URL_SEPARATOR_PATTERN = Pattern.compile("([^/]*)/");
    private static final String ROOT_REPLACE_PATTERN = "../";

    public static String asPath(String path) {
        return URL_SEPARATOR + PathUtils.normalizePath(path);
    }

    public static String asDirPath(String path) {
        return URL_SEPARATOR + PathUtils.normalizePath(path) + URL_SEPARATOR;
    }

    public static final String normalizePath(String path) {
        String normalizedPath = path.replaceAll("//", URL_SEPARATOR);
        StringTokenizer tk = new StringTokenizer(normalizedPath, URL_SEPARATOR);
        StringBuffer sb = new StringBuffer();
        while (tk.hasMoreTokens()) {
            sb.append(tk.nextToken());
            if (!tk.hasMoreTokens()) continue;
            sb.append(URL_SEPARATOR);
        }
        return sb.toString();
    }

    public static String getParentPath(String path) {
        String parentPath = null;
        if (StringUtils.isBlank(path)) {
            parentPath = "";
        } else {
            int index;
            parentPath = path;
            if (parentPath.length() > 1 && parentPath.endsWith(URL_SEPARATOR)) {
                parentPath = parentPath.substring(0, parentPath.length() - 2);
            }
            if ((index = parentPath.lastIndexOf(URL_SEPARATOR)) > 0) {
                return parentPath.substring(0, index + 1);
            }
            parentPath = URL_SEPARATOR;
        }
        return parentPath;
    }

    public static String concatWebPath(String basePath, String fullFilenameToAdd) {
        if (fullFilenameToAdd == null || basePath == null && (fullFilenameToAdd.length() == 0 || fullFilenameToAdd.charAt(0) != '/')) {
            return null;
        }
        if (basePath == null) {
            basePath = "";
        }
        if (basePath.length() > 1 && basePath.charAt(basePath.length() - 1) != '/') {
            basePath = PathUtils.getParentPath(basePath);
        }
        int len = basePath.length();
        String fullPath = null;
        if (len == 0) {
            return PathUtils.doNormalizeIgnoreOtherSeparator(fullFilenameToAdd, true);
        }
        char ch = basePath.charAt(len - 1);
        fullPath = ch == '/' ? basePath + fullFilenameToAdd : basePath + '/' + fullFilenameToAdd;
        return PathUtils.doNormalizeIgnoreOtherSeparator(fullPath, true);
    }

    public static final String getRelativeWebPath(String oldPath, String newPath) {
        if (StringUtils.isBlank(oldPath) || StringUtils.isBlank(newPath)) {
            return "";
        }
        String resultPath = PathUtils.buildRelativePath(newPath, oldPath, '/');
        if (newPath.endsWith(URL_SEPARATOR) && !resultPath.endsWith(URL_SEPARATOR)) {
            return resultPath + URL_SEPARATOR;
        }
        return resultPath;
    }

    public static String getRootRelativePath(String url) {
        StringBuffer retval = new StringBuffer();
        if (StringUtils.isNotBlank(url)) {
            Matcher matcher = URL_SEPARATOR_PATTERN.matcher(url);
            boolean first = true;
            while (matcher.find()) {
                if (first) {
                    matcher.appendReplacement(retval, "");
                    first = false;
                    continue;
                }
                matcher.appendReplacement(retval, ROOT_REPLACE_PATTERN);
            }
        }
        return retval.toString();
    }

    public static String toFilePath(URL url) {
        String filePath;
        try {
            filePath = URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Can never happen", e);
        }
        if (filePath.endsWith(URL_SEPARATOR)) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        return filePath;
    }

    private static String doNormalizeIgnoreOtherSeparator(String filename, boolean keepSeparator) {
        int i;
        int size = filename.length();
        if (size == 0) {
            return filename;
        }
        int prefix = 0;
        char[] array = new char[size + 2];
        filename.getChars(0, filename.length(), array, 0);
        boolean lastIsDirectory = true;
        if (array[size - 1] != '/') {
            array[size++] = 47;
            lastIsDirectory = false;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != '/' || array[i - 1] != '/') continue;
            System.arraycopy(array, i, array, i - 1, size - i);
            --size;
            --i;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != '/' || array[i - 1] != '.' || i != prefix + 1 && array[i - 2] != '/') continue;
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            System.arraycopy(array, i + 1, array, i - 1, size - i);
            size -= 2;
            --i;
        }
        block2: for (i = prefix + 2; i < size; ++i) {
            if (array[i] != '/' || array[i - 1] != '.' || array[i - 2] != '.' || i != prefix + 2 && array[i - 3] != '/') continue;
            if (i == prefix + 2) {
                return null;
            }
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            for (int j = i - 4; j >= prefix; --j) {
                if (array[j] != '/') continue;
                System.arraycopy(array, i + 1, array, j + 1, size - i);
                size -= i - j;
                i = j + 1;
                continue block2;
            }
            System.arraycopy(array, i + 1, array, prefix, size - i);
            size -= i + 1 - prefix;
            i = prefix + 1;
        }
        if (size <= 0) {
            return "";
        }
        if (size <= prefix) {
            return new String(array, 0, size);
        }
        if (lastIsDirectory && keepSeparator) {
            return new String(array, 0, size);
        }
        return new String(array, 0, size - 1);
    }

    private static final String buildRelativePath(String toPath, String fromPath, char separatorChar) {
        StringTokenizer toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        StringTokenizer fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        int count = 0;
        while (toTokeniser.hasMoreTokens() && fromTokeniser.hasMoreTokens() && !(separatorChar == '\\' ? !fromTokeniser.nextToken().equalsIgnoreCase(toTokeniser.nextToken()) : !fromTokeniser.nextToken().equals(toTokeniser.nextToken()))) {
            ++count;
        }
        toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        while (count-- > 0) {
            fromTokeniser.nextToken();
            toTokeniser.nextToken();
        }
        StringBuffer relativePath = new StringBuffer();
        while (fromTokeniser.hasMoreTokens()) {
            fromTokeniser.nextToken();
            relativePath.append("..");
            if (!fromTokeniser.hasMoreTokens()) continue;
            relativePath.append(separatorChar);
        }
        if (relativePath.length() != 0 && toTokeniser.hasMoreTokens()) {
            relativePath.append(separatorChar);
        }
        while (toTokeniser.hasMoreTokens()) {
            relativePath.append(toTokeniser.nextToken());
            if (!toTokeniser.hasMoreTokens()) continue;
            relativePath.append(separatorChar);
        }
        return relativePath.toString();
    }

    private PathUtils() {
    }
}

