/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.utils;

public class EnumUtils {
    public static <E extends Enum<E>> String printPossibleValuesOf(Class<E> enumClass) {
        StringBuilder possibleValues = new StringBuilder();
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        for (int i = 0; i < enumConstants.length; ++i) {
            possibleValues.append("'").append(enumConstants[i].name().toLowerCase()).append("'");
            if (i < enumConstants.length - 2) {
                possibleValues.append(", ");
                continue;
            }
            if (i != enumConstants.length - 2) continue;
            possibleValues.append(" and ");
        }
        possibleValues.append(".");
        return possibleValues.toString();
    }

    public static <E extends Enum<E>> E getEnum(String enumName, Class<E> enumType) {
        if (enumName == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumType, enumName.toUpperCase().trim());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

