/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.storage;

import com.github.dandelion.core.storage.BundleDag;
import com.github.dandelion.core.storage.BundleStorageUnit;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TopologicalSorter {
    private static final Integer NOT_VISTITED = new Integer(0);
    private static final Integer VISITING = new Integer(1);
    private static final Integer VISITED = new Integer(2);

    public static List<BundleStorageUnit> sort(BundleDag graph) {
        return TopologicalSorter.dfs(graph);
    }

    public static List<BundleStorageUnit> sort(BundleStorageUnit vertex) {
        LinkedList<BundleStorageUnit> retValue = new LinkedList<BundleStorageUnit>();
        TopologicalSorter.dfsVisit(vertex, new HashMap<BundleStorageUnit, Integer>(), retValue);
        return retValue;
    }

    private static List<BundleStorageUnit> dfs(BundleDag graph) {
        LinkedList<BundleStorageUnit> retValue = new LinkedList<BundleStorageUnit>();
        HashMap<BundleStorageUnit, Integer> vertexStateMap = new HashMap<BundleStorageUnit, Integer>();
        for (BundleStorageUnit vertex : graph.getVerticies()) {
            if (!TopologicalSorter.isNotVisited(vertex, vertexStateMap)) continue;
            TopologicalSorter.dfsVisit(vertex, vertexStateMap, retValue);
        }
        return retValue;
    }

    private static boolean isNotVisited(BundleStorageUnit vertex, Map<BundleStorageUnit, Integer> vertexStateMap) {
        Integer state = vertexStateMap.get(vertex);
        return state == null || NOT_VISTITED.equals(state);
    }

    private static void dfsVisit(BundleStorageUnit vertex, Map<BundleStorageUnit, Integer> vertexStateMap, List<BundleStorageUnit> list) {
        vertexStateMap.put(vertex, VISITING);
        for (BundleStorageUnit v : vertex.getChildren()) {
            if (!TopologicalSorter.isNotVisited(v, vertexStateMap)) continue;
            TopologicalSorter.dfsVisit(v, vertexStateMap, list);
        }
        vertexStateMap.put(vertex, VISITED);
        list.add(vertex);
    }
}

