/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.storage;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.dandelion.core.asset.AssetType;
import com.github.dandelion.core.storage.AssetStorageUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BundleStorageUnit {
    private String name;
    private List<String> dependencies;
    private Set<AssetStorageUnit> assetStorageUnits = new LinkedHashSet<AssetStorageUnit>();
    private List<BundleStorageUnit> children = new LinkedList<BundleStorageUnit>();
    private List<BundleStorageUnit> parents = new LinkedList<BundleStorageUnit>();

    public BundleStorageUnit() {
    }

    public BundleStorageUnit(String name) {
        this.name = name;
    }

    public BundleStorageUnit(String name, Set<AssetStorageUnit> assetStorageUnits) {
        this.name = name;
        this.assetStorageUnits = assetStorageUnits;
    }

    @JsonProperty(value="bundle")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addDependency(String dep) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.add(dep);
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    @JsonProperty(value="assets")
    @JsonDeserialize(as=LinkedHashSet.class)
    public Set<AssetStorageUnit> getAssetStorageUnits() {
        return this.assetStorageUnits;
    }

    public Set<String> getAssetStorageUnitNames() {
        HashSet<String> asus = new HashSet<String>();
        if (this.assetStorageUnits != null) {
            for (AssetStorageUnit asu : this.assetStorageUnits) {
                asus.add(asu.getName());
            }
        }
        return asus;
    }

    public Set<String> getJsAssetStorageUnitNames() {
        HashSet<String> asus = new HashSet<String>();
        if (this.assetStorageUnits != null) {
            for (AssetStorageUnit asu : this.assetStorageUnits) {
                if (!asu.getType().equals((Object)AssetType.js)) continue;
                asus.add(asu.getName());
            }
        }
        return asus;
    }

    public Set<String> getCssAssetStorageUnitNames() {
        HashSet<String> asus = new HashSet<String>();
        if (this.assetStorageUnits != null) {
            for (AssetStorageUnit asu : this.assetStorageUnits) {
                if (!asu.getType().equals((Object)AssetType.css)) continue;
                asus.add(asu.getName());
            }
        }
        return asus;
    }

    public void setAssetStorageUnits(Set<AssetStorageUnit> assetStorageUnits) {
        this.assetStorageUnits = assetStorageUnits;
    }

    public void addEdgeTo(BundleStorageUnit vertex) {
        this.children.add(vertex);
    }

    public void removeEdgeTo(BundleStorageUnit vertex) {
        this.children.remove(vertex);
    }

    public void addEdgeFrom(BundleStorageUnit vertex) {
        this.parents.add(vertex);
    }

    public void removeEdgeFrom(BundleStorageUnit vertex) {
        this.parents.remove(vertex);
    }

    public List<BundleStorageUnit> getChildren() {
        return this.children;
    }

    public List<String> getChildNames() {
        ArrayList<String> retValue = new ArrayList<String>(this.children.size());
        for (BundleStorageUnit vertex : this.children) {
            retValue.add(vertex.getName());
        }
        return retValue;
    }

    public List<BundleStorageUnit> getParents() {
        return this.parents;
    }

    public List<String> getParentBundleNames() {
        ArrayList<String> retValue = new ArrayList<String>(this.parents.size());
        for (BundleStorageUnit vertex : this.parents) {
            retValue.add(vertex.getName());
        }
        return retValue;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public boolean isRoot() {
        return this.parents.size() == 0;
    }

    public boolean isConnected() {
        return this.isRoot() || this.isLeaf();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleStorageUnit other = (BundleStorageUnit)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "BundleStorageUnit [name=" + this.name + ", dependencies=" + this.dependencies + "]";
    }
}

