/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.storage;

import com.github.dandelion.core.storage.AssetStorageUnit;
import com.github.dandelion.core.storage.BundleDag;
import com.github.dandelion.core.storage.BundleStorageUnit;
import com.github.dandelion.core.storage.TopologicalSorter;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleStorage {
    private static final Logger LOG = LoggerFactory.getLogger(BundleStorage.class);
    private BundleDag bundleDag = new BundleDag();

    public BundleDag getBundleDag() {
        return this.bundleDag;
    }

    public BundleDag storeBundles(List<BundleStorageUnit> bundleStorageUnits) {
        for (BundleStorageUnit bsu : bundleStorageUnits) {
            BundleStorageUnit bsuToAdd = this.bundleDag.addVertexIfNeeded(bsu);
            if (bsu.getDependencies() != null && !bsu.getDependencies().isEmpty()) {
                for (String dependency : bsu.getDependencies()) {
                    BundleStorageUnit to = this.bundleDag.addVertexIfNeeded(dependency);
                    this.bundleDag.addEdge(bsuToAdd, to);
                }
            } else {
                bsuToAdd = this.bundleDag.addVertexIfNeeded(bsu);
            }
            if (bsu.getAssetStorageUnits() == null) continue;
            for (AssetStorageUnit asu : bsu.getAssetStorageUnits()) {
                boolean exists = false;
                for (BundleStorageUnit existingBundle : this.bundleDag.getVerticies()) {
                    for (AssetStorageUnit existingAsu : existingBundle.getAssetStorageUnits()) {
                        if (!existingAsu.getName().equalsIgnoreCase(asu.getName()) || !existingAsu.getType().equals((Object)asu.getType())) continue;
                        LOG.debug("Replacing asset '{}' ({}) from the bundle '{}' by the asset {} ({}) from the bundle {}.", new Object[]{existingAsu.getName(), existingAsu.getVersion(), existingBundle.getName(), asu.getName(), asu.getVersion(), bsuToAdd.getName()});
                        existingAsu.setVersion(asu.getVersion());
                        existingAsu.setLocations(asu.getLocations());
                        existingAsu.setDom(asu.getDom());
                        existingAsu.setType(asu.getType());
                        existingAsu.setAttributes(asu.getAttributes());
                        existingAsu.setAttributesOnlyName(asu.getAttributesOnlyName());
                        exists = true;
                        break;
                    }
                    if (!exists) continue;
                    break;
                }
                if (exists) continue;
                LOG.debug("Adding {} '{}' ({}) to the bundle '{}'", new Object[]{asu.getType(), asu.getName(), asu.getVersion(), bsuToAdd.getName()});
                bsuToAdd.getAssetStorageUnits().add(asu);
            }
        }
        return this.bundleDag;
    }

    public void checkBundleDag() {
        for (BundleStorageUnit bsu : this.bundleDag.getVerticies()) {
            if (bsu.getAssetStorageUnits() != null && !bsu.getAssetStorageUnits().isEmpty()) continue;
            LOG.warn("Empty bundle: {}", (Object)bsu.getName());
        }
    }

    public Set<BundleStorageUnit> bundlesFor(String bundleName) {
        BundleStorageUnit bsu = this.bundleDag.getVertex(bundleName);
        if (bsu != null) {
            HashSet<BundleStorageUnit> retval = null;
            if (bsu.isLeaf()) {
                retval = new HashSet<BundleStorageUnit>(1);
                retval.add(bsu);
            } else {
                retval = new LinkedHashSet<BundleStorageUnit>(TopologicalSorter.sort(bsu));
            }
            return retval;
        }
        return Collections.emptySet();
    }

    public Set<BundleStorageUnit> bundlesFor(String ... bundleNames) {
        LinkedHashSet<BundleStorageUnit> retval = new LinkedHashSet<BundleStorageUnit>();
        for (String bundleName : bundleNames) {
            retval.addAll(this.bundlesFor(bundleName.trim()));
        }
        return retval;
    }
}

