/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.storage;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.storage.BundleCycleDetector;
import com.github.dandelion.core.storage.BundleStorageUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BundleDag {
    private Map<String, BundleStorageUnit> vertexMap = new HashMap<String, BundleStorageUnit>();
    private List<BundleStorageUnit> vertexList = new ArrayList<BundleStorageUnit>();

    public List<BundleStorageUnit> getVerticies() {
        return this.vertexList;
    }

    public Set<String> getBundleNames() {
        return this.vertexMap.keySet();
    }

    public BundleStorageUnit addVertexIfNeeded(BundleStorageUnit bsu) {
        return this.addVertexIfNeeded(bsu.getName());
    }

    public BundleStorageUnit addVertexIfNeeded(String bundleName) {
        BundleStorageUnit retValue = null;
        if (this.vertexMap.containsKey(bundleName)) {
            retValue = this.vertexMap.get(bundleName);
        } else {
            retValue = new BundleStorageUnit(bundleName);
            this.vertexMap.put(bundleName, retValue);
            this.vertexList.add(retValue);
        }
        return retValue;
    }

    public void addEdge(BundleStorageUnit from, BundleStorageUnit to) {
        from.addEdgeTo(to);
        to.addEdgeFrom(from);
        List<BundleStorageUnit> cycle = BundleCycleDetector.introducesCycle(to);
        if (cycle != null) {
            StringBuilder sb = new StringBuilder("A cycle has been detected in the asset graph for the bundle ");
            sb.append(from.getName());
            sb.append(".");
            throw new DandelionException(sb.toString());
        }
    }

    public void removeEdge(BundleStorageUnit from, BundleStorageUnit to) {
        from.removeEdgeTo(to);
        to.removeEdgeFrom(from);
    }

    public Map<String, BundleStorageUnit> getVertexMap() {
        return this.vertexMap;
    }

    public BundleStorageUnit getVertex(String bundleName) {
        BundleStorageUnit retValue = this.vertexMap.get(bundleName);
        return retValue;
    }

    public boolean hasEdge(String bundleName1, String bundleName2) {
        BundleStorageUnit b1 = this.getVertex(bundleName1);
        BundleStorageUnit b2 = this.getVertex(bundleName2);
        return b1.getChildren().contains(b2);
    }

    public List<String> getChildLabels(String bundleName) {
        BundleStorageUnit vertex = this.getVertex(bundleName);
        return vertex.getChildNames();
    }

    public boolean isConnected(String bundleName) {
        BundleStorageUnit vertex = this.getVertex(bundleName);
        return vertex.isConnected();
    }
}

