/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.storage;

import com.github.dandelion.core.storage.BundleDag;
import com.github.dandelion.core.storage.BundleStorageUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BundleCycleDetector {
    private static Integer NOT_VISTITED = new Integer(0);
    private static Integer VISITING = new Integer(1);
    private static Integer VISITED = new Integer(2);

    public static List<BundleStorageUnit> hasCycle(BundleDag graph) {
        List<BundleStorageUnit> verticies = graph.getVerticies();
        HashMap<BundleStorageUnit, Integer> vertexStateMap = new HashMap<BundleStorageUnit, Integer>();
        List<BundleStorageUnit> retValue = null;
        for (BundleStorageUnit vertex : verticies) {
            if (BundleCycleDetector.isNotVisited(vertex, vertexStateMap) && (retValue = BundleCycleDetector.introducesCycle(vertex, vertexStateMap)) != null) break;
        }
        return retValue;
    }

    public static List<BundleStorageUnit> introducesCycle(BundleStorageUnit vertex, Map<BundleStorageUnit, Integer> vertexStateMap) {
        LinkedList<BundleStorageUnit> cycleStack = new LinkedList<BundleStorageUnit>();
        boolean hasCycle = BundleCycleDetector.dfsVisit(vertex, cycleStack, vertexStateMap);
        if (hasCycle) {
            BundleStorageUnit firstBsu = cycleStack.getFirst();
            int pos = cycleStack.lastIndexOf(firstBsu);
            List<BundleStorageUnit> cycle = cycleStack.subList(0, pos + 1);
            Collections.reverse(cycle);
            return cycle;
        }
        return null;
    }

    public static List<BundleStorageUnit> introducesCycle(BundleStorageUnit vertex) {
        HashMap<BundleStorageUnit, Integer> vertexStateMap = new HashMap<BundleStorageUnit, Integer>();
        return BundleCycleDetector.introducesCycle(vertex, vertexStateMap);
    }

    private static boolean isNotVisited(BundleStorageUnit vertex, Map<BundleStorageUnit, Integer> vertexStateMap) {
        Integer state = vertexStateMap.get(vertex);
        return state == null || NOT_VISTITED.equals(state);
    }

    private static boolean isVisiting(BundleStorageUnit vertex, Map<BundleStorageUnit, Integer> vertexStateMap) {
        Integer state = vertexStateMap.get(vertex);
        return VISITING.equals(state);
    }

    private static boolean dfsVisit(BundleStorageUnit vertex, LinkedList<BundleStorageUnit> cycle, Map<BundleStorageUnit, Integer> vertexStateMap) {
        cycle.addFirst(vertex);
        vertexStateMap.put(vertex, VISITING);
        for (BundleStorageUnit v : vertex.getChildren()) {
            if (BundleCycleDetector.isNotVisited(v, vertexStateMap)) {
                boolean hasCycle = BundleCycleDetector.dfsVisit(v, cycle, vertexStateMap);
                if (!hasCycle) continue;
                return true;
            }
            if (!BundleCycleDetector.isVisiting(v, vertexStateMap)) continue;
            cycle.addFirst(v);
            return true;
        }
        vertexStateMap.put(vertex, VISITED);
        cycle.removeFirst();
        return false;
    }
}

