/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.storage;

import com.github.dandelion.core.asset.AssetDomPosition;
import com.github.dandelion.core.asset.AssetType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AssetStorageUnit {
    private String name;
    private String version;
    private AssetType type;
    private AssetDomPosition dom;
    private Map<String, String> locations;
    private Map<String, String> attributes;
    private String[] attributesOnlyName;
    private String cacheKey;

    public AssetStorageUnit() {
    }

    public AssetStorageUnit(String name, String version, AssetType type) {
        this.name = name;
        this.version = version;
        this.type = type;
    }

    public AssetStorageUnit(String name, Map<String, String> locations) {
        this.name = name;
        this.locations = locations;
    }

    public AssetStorageUnit(String name, String version, AssetType type, AssetDomPosition position) {
        this.name = name;
        this.version = version;
        this.type = type;
        this.dom = position;
    }

    public AssetStorageUnit(String name, String version, AssetType type, Map<String, String> locations) {
        this.name = name;
        this.version = version;
        this.type = type;
        this.locations = locations;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public AssetType getType() {
        return this.type;
    }

    public void setType(AssetType type) {
        this.type = type;
    }

    public AssetDomPosition getDom() {
        return this.dom;
    }

    public void setDom(AssetDomPosition dom) {
        this.dom = dom;
    }

    public Map<String, String> getLocations() {
        return this.locations;
    }

    public void setLocations(Map<String, String> locations) {
        this.locations = locations;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String[] getAttributesOnlyName() {
        if (this.attributesOnlyName == null) {
            return new String[0];
        }
        return this.attributesOnlyName;
    }

    public void setAttributesOnlyName(String[] attributesOnlyName) {
        this.attributesOnlyName = attributesOnlyName;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public boolean isValid() {
        return this.name != null && this.version != null && this.type != null && this.locations != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssetStorageUnit other = (AssetStorageUnit)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public String getAssetKey() {
        return this.name + "." + (Object)((Object)this.type);
    }

    public void addAttribute(String attributeName, String attributeValue) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(attributeName, attributeValue);
    }

    public void addAttribute(String attributeName) {
        if (this.attributesOnlyName == null) {
            this.attributesOnlyName = new String[]{attributeName};
        } else {
            Arrays.copyOf(this.attributesOnlyName, this.attributesOnlyName.length + 1);
            this.attributesOnlyName[this.attributesOnlyName.length] = attributeName;
        }
    }

    public String toString() {
        return "AssetStorageUnit [name=" + this.name + ", version=" + this.version + ", type=" + (Object)((Object)this.type) + ", dom=" + (Object)((Object)this.dom) + ", locations=" + this.locations + ", attributes=" + this.attributes + ", attributesOnlyName=" + Arrays.toString(this.attributesOnlyName) + "]";
    }

    public String toLog() {
        return "'" + this.name + "' (" + (Object)((Object)this.type) + ", v" + this.version + ")";
    }
}

