/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.monitoring;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dandelion.core.Context;
import com.github.dandelion.core.asset.Asset;
import com.github.dandelion.core.asset.AssetDomPosition;
import com.github.dandelion.core.asset.AssetMapper;
import com.github.dandelion.core.asset.AssetQuery;
import com.github.dandelion.core.storage.AssetStorageUnit;
import com.github.dandelion.core.storage.BundleStorageUnit;
import com.github.dandelion.core.utils.ResourceUtils;
import com.github.dandelion.core.utils.UrlUtils;
import com.github.dandelion.core.web.AssetRequestContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GraphViewer {
    private static ObjectMapper mapper;
    private AssetMapper assetMapper;
    private Context context;

    public GraphViewer(Context context) {
        this.context = context;
        mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
    }

    public String getView(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.assetMapper = new AssetMapper(request, this.context);
        StringBuilder sbNodesRequest = new StringBuilder();
        StringBuilder sbNodesApplication = new StringBuilder();
        StringBuilder sbHead = new StringBuilder();
        StringBuilder sbBody = new StringBuilder();
        String graphView = ResourceUtils.getContentFromInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream("dandelion/internal/graphViewer/graphViewer.html"));
        Set<Asset> assetsHead = new AssetQuery(request, this.context).withPosition(AssetDomPosition.head).perform();
        Iterator<Asset> iteratorAssetHead = assetsHead.iterator();
        while (iteratorAssetHead.hasNext()) {
            sbHead.append("    &lt;link href=\"" + iteratorAssetHead.next().getFinalLocation() + "\" />");
            if (!iteratorAssetHead.hasNext()) continue;
            sbHead.append('\n');
        }
        Set<Asset> assetsBody = new AssetQuery(request, this.context).withPosition(AssetDomPosition.body).perform();
        Iterator<Asset> iteratorAssetBody = assetsBody.iterator();
        while (iteratorAssetBody.hasNext()) {
            sbBody.append("    &lt;script src=\"" + iteratorAssetBody.next().getFinalLocation() + "\"></script>");
            if (!iteratorAssetBody.hasNext()) continue;
            sbBody.append('\n');
        }
        Set<BundleStorageUnit> bsuRequest = this.context.getBundleStorage().bundlesFor(AssetRequestContext.get((ServletRequest)request).getBundles(true));
        for (BundleStorageUnit bsu : bsuRequest) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("label", bsu.getName());
            map.put("assets", this.convertToD3Assets(bsu.getAssetStorageUnits()));
            String bundle = mapper.writeValueAsString(map);
            sbNodesRequest.append("requestGraph.addNode('" + bsu.getName() + "'," + bundle + ");").append('\n');
        }
        HashSet<String> edgesRequest = new HashSet<String>();
        for (BundleStorageUnit bsu : bsuRequest) {
            if (bsu.getChildren() == null || bsu.getChildren().isEmpty()) continue;
            for (BundleStorageUnit childBsu : bsu.getChildren()) {
                edgesRequest.add("requestGraph.addEdge(null, '" + bsu.getName() + "', '" + childBsu.getName() + "', { label: \"depends on\" });");
            }
        }
        for (String edge : edgesRequest) {
            sbNodesRequest.append(edge).append('\n');
        }
        List<BundleStorageUnit> allBundles = this.context.getBundleStorage().getBundleDag().getVerticies();
        for (BundleStorageUnit bsu : allBundles) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("label", bsu.getName());
            String bundle = mapper.writeValueAsString(map);
            sbNodesApplication.append("applicationGraph.addNode('" + bsu.getName() + "'," + bundle + ");").append('\n');
        }
        HashSet<String> edgesApplication = new HashSet<String>();
        for (BundleStorageUnit bsu : allBundles) {
            if (bsu.getChildren() == null || bsu.getChildren().isEmpty()) continue;
            for (BundleStorageUnit childBsu : bsu.getChildren()) {
                edgesApplication.add("applicationGraph.addEdge(null, '" + bsu.getName() + "', '" + childBsu.getName() + "', { label: \"depends on\" });");
            }
        }
        for (String edge : edgesApplication) {
            sbNodesApplication.append(edge).append('\n');
        }
        String currentUri = UrlUtils.getCurrentUri(request).toString();
        graphView = graphView.replace("[NODES_REQUEST]", sbNodesRequest.toString());
        graphView = graphView.replace("[NODES_APPLICATION]", sbNodesApplication.toString());
        graphView = graphView.replace("[CURRENT_URL]", currentUri.substring(0, currentUri.indexOf("showGraph") - 1));
        graphView = graphView.replace("[HEAD]", sbHead.toString());
        graphView = graphView.replace("[BODY]", sbBody.toString());
        return graphView;
    }

    public List<D3Asset> convertToD3Assets(Set<AssetStorageUnit> asus) {
        ArrayList<D3Asset> d3Assets = new ArrayList<D3Asset>();
        Set<Asset> assets = this.assetMapper.mapToAssets(asus);
        for (Asset a : assets) {
            d3Assets.add(new D3Asset(a));
        }
        return d3Assets;
    }

    public class D3Asset {
        private String url;
        private String name;
        private String version;
        private String type;
        private String location;

        public D3Asset(Asset a) {
            this.name = a.getName();
            this.version = a.getVersion();
            this.type = a.getType().toString();
            this.location = a.getConfigLocationKey();
            this.url = a.getFinalLocation();
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }
    }
}

