/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.html;

import java.util.Map;

public abstract class HtmlTag {
    protected String id;
    protected StringBuffer cssClass;
    protected StringBuffer cssStyle;
    protected Map<String, String> attributes;
    private String[] attributesOnlyName;

    public abstract String toHtml();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public StringBuffer getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(StringBuffer cssClass) {
        this.cssClass = cssClass;
    }

    public StringBuffer getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(StringBuffer cssStyle) {
        this.cssStyle = cssStyle;
    }

    public void addCssClass(String cssClass) {
        if (this.cssClass == null) {
            this.cssClass = new StringBuffer();
        }
        this.cssClass.append(" ");
        this.cssClass.append(cssClass);
    }

    public void addCssStyle(String cssStyle) {
        if (this.cssStyle == null) {
            this.cssStyle = new StringBuffer();
        }
        this.cssStyle.append(cssStyle);
        if (!cssStyle.endsWith(";")) {
            this.cssStyle.append(";");
        }
    }

    public void addAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void addAttributesOnlyName(String ... attributesOnlyName) {
        this.attributesOnlyName = attributesOnlyName;
    }

    protected String attributesToHtml() {
        StringBuilder html = new StringBuilder();
        if (this.attributes != null) {
            for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
                html.append(" ");
                html.append(attribute.getKey());
                html.append("=\"");
                html.append(attribute.getValue());
                html.append("\"");
            }
        }
        return html.toString();
    }

    public String attributesOnlyNameToHtml() {
        StringBuilder html = new StringBuilder();
        if (this.attributesOnlyName != null) {
            for (String attribute : this.attributesOnlyName) {
                html.append(" ");
                html.append(attribute);
            }
        }
        return html.toString();
    }
}

