/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.config;

import com.github.dandelion.core.config.ConfigurationLoader;
import com.github.dandelion.core.utils.PropertiesUtils;
import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.core.utils.UTF8Control;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardConfigurationLoader
implements ConfigurationLoader {
    private static Logger LOG = LoggerFactory.getLogger(StandardConfigurationLoader.class);
    public static final String DANDELION_USER_PROPERTIES = "dandelion";
    public static final String DANDELION_CONFIGURATION = "dandelion.configuration";

    @Override
    public Properties loadUserConfiguration() {
        LOG.debug("Loading user configuration...");
        ResourceBundle userBundle = null;
        ResourceBundle.clearCache();
        if (StringUtils.isNotBlank(System.getProperty(DANDELION_CONFIGURATION))) {
            String path = System.getProperty(DANDELION_CONFIGURATION);
            try {
                URL resourceURL = new File(path).toURI().toURL();
                URLClassLoader urlLoader = new URLClassLoader(new URL[]{resourceURL});
                userBundle = ResourceBundle.getBundle(DANDELION_USER_PROPERTIES, Locale.getDefault(), urlLoader, new UTF8Control());
                LOG.debug("User configuration loaded");
            }
            catch (MalformedURLException e) {
                LOG.warn("Wrong path to the externalized bundle", (Throwable)e);
            }
            catch (MissingResourceException e) {
                LOG.info("No *.properties file in {}. Trying to lookup in classpath...", (Object)path);
            }
        }
        if (userBundle == null) {
            try {
                userBundle = ResourceBundle.getBundle(DANDELION_USER_PROPERTIES, Locale.getDefault(), new UTF8Control());
                LOG.debug("User configuration loaded");
            }
            catch (MissingResourceException e) {
                try {
                    userBundle = ResourceBundle.getBundle("dandelion/dandelion", Locale.getDefault(), Thread.currentThread().getContextClassLoader(), new UTF8Control());
                    LOG.debug("User configuration loaded");
                }
                catch (MissingResourceException mre) {
                    LOG.debug("No custom configuration. Using default one.");
                }
            }
        }
        return PropertiesUtils.bundleToProperties(userBundle);
    }
}

