/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.config;

import com.github.dandelion.core.DandelionMode;
import com.github.dandelion.core.config.DandelionConfig;
import com.github.dandelion.core.utils.PropertiesUtils;
import com.github.dandelion.core.utils.StringUtils;
import java.util.List;
import java.util.Properties;
import javax.servlet.FilterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static Logger LOG = LoggerFactory.getLogger(Configuration.class);
    private FilterConfig filterConfig;
    private Properties userProperties;
    private boolean servlet3Enabled;
    private boolean jmxEnabled;
    private DandelionMode dandelionMode;
    private boolean minificationEnabled;
    private List<String> assetLocationsResolutionStrategy;
    private List<String> assetProcessors;
    private String assetProcessorEncoding;
    private List<String> assetJsExcludes;
    private List<String> assetCssExcludes;
    private String cacheName;
    private int cacheAssetMaxSize;
    private int cacheRequestMaxSize;
    private String cacheManagerName;
    private String cacheConfigurationLocation;
    private List<String> bundleIncludes;
    private List<String> bundleExcludes;

    public Configuration(FilterConfig filterConfig, Properties userProperties) {
        this.filterConfig = filterConfig;
        this.userProperties = userProperties;
        try {
            this.dandelionMode = DandelionMode.valueOf(this.readConfig(DandelionConfig.DANDELION_MODE).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("The '{}' property is incorrectly configured. Falling back to the default value ({})", (Object)DandelionConfig.DANDELION_MODE.getName(), (Object)DandelionConfig.DANDELION_MODE.getDefaultDevValue());
            this.dandelionMode = DandelionMode.DEVELOPMENT;
        }
        if (this.dandelionMode.equals((Object)DandelionMode.DEVELOPMENT)) {
            LOG.info("===========================================");
            LOG.info("");
            LOG.info("Dandelion development mode enabled.");
            LOG.info("");
            LOG.info("===========================================");
        }
        this.minificationEnabled = Boolean.parseBoolean(this.readConfig(DandelionConfig.MINIFICATION));
        this.jmxEnabled = Boolean.parseBoolean(this.readConfig(DandelionConfig.JMX_ENABLED));
        this.bundleIncludes = PropertiesUtils.propertyAsList(this.readConfig(DandelionConfig.BUNDLE_INCLUDES), ",");
        this.bundleExcludes = PropertiesUtils.propertyAsList(this.readConfig(DandelionConfig.BUNDLE_EXCLUDES), ",");
        this.assetLocationsResolutionStrategy = PropertiesUtils.propertyAsList(this.readConfig(DandelionConfig.ASSET_LOCATIONS_RESOLUTION_STRATEGY), ",");
        this.assetProcessors = PropertiesUtils.propertyAsList(this.readConfig(DandelionConfig.ASSET_PROCESSORS), ",");
        this.assetProcessorEncoding = this.readConfig(DandelionConfig.ASSET_PROCESSORS_ENCODING);
        this.assetJsExcludes = PropertiesUtils.propertyAsList(this.readConfig(DandelionConfig.ASSET_JS_EXCLUDES), ",");
        this.assetCssExcludes = PropertiesUtils.propertyAsList(this.readConfig(DandelionConfig.ASSET_CSS_EXCLUDES), ",");
        this.cacheName = this.readConfig(DandelionConfig.CACHE_NAME);
        try {
            this.cacheAssetMaxSize = Integer.parseInt(this.readConfig(DandelionConfig.CACHE_ASSET_MAX_SIZE));
        }
        catch (NumberFormatException e) {
            LOG.warn("The '{}' property is incorrectly configured. Falling back to the default value ({})", (Object)DandelionConfig.CACHE_ASSET_MAX_SIZE.getName(), (Object)DandelionConfig.CACHE_ASSET_MAX_SIZE.getDefaultDevValue());
            this.cacheAssetMaxSize = Integer.parseInt(DandelionConfig.CACHE_ASSET_MAX_SIZE.getDefaultDevValue());
        }
        try {
            this.cacheRequestMaxSize = Integer.parseInt(this.readConfig(DandelionConfig.CACHE_REQUEST_MAX_SIZE));
        }
        catch (NumberFormatException e) {
            LOG.warn("The '{}' property is incorrectly configured. Falling back to the default value ({})", (Object)DandelionConfig.CACHE_REQUEST_MAX_SIZE.getName(), (Object)DandelionConfig.CACHE_REQUEST_MAX_SIZE.getDefaultDevValue());
            this.cacheRequestMaxSize = Integer.parseInt(DandelionConfig.CACHE_REQUEST_MAX_SIZE.getDefaultDevValue());
        }
        this.cacheManagerName = this.readConfig(DandelionConfig.CACHE_MANAGER_NAME);
        this.cacheConfigurationLocation = this.readConfig(DandelionConfig.CACHE_CONFIGURATION_LOCATION);
        String overrideServlet3 = this.readConfig(DandelionConfig.OVERRIDE_SERVLET3);
        this.servlet3Enabled = StringUtils.isBlank(overrideServlet3) && filterConfig != null ? filterConfig.getServletContext().getMajorVersion() == 3 : Boolean.parseBoolean(overrideServlet3);
    }

    public DandelionMode getDandelionMode() {
        return this.dandelionMode;
    }

    public boolean isMinificationEnabled() {
        return this.minificationEnabled;
    }

    public List<String> getAssetLocationsResolutionStrategy() {
        return this.assetLocationsResolutionStrategy;
    }

    public List<String> getAssetProcessors() {
        return this.assetProcessors;
    }

    public String getAssetProcessorEncoding() {
        return this.assetProcessorEncoding;
    }

    public List<String> getAssetJsExcludes() {
        return this.assetJsExcludes;
    }

    public List<String> getAssetCssExcludes() {
        return this.assetCssExcludes;
    }

    public int getCacheAssetMaxSize() {
        return this.cacheAssetMaxSize;
    }

    public int getCacheRequestMaxSize() {
        return this.cacheRequestMaxSize;
    }

    public String getCacheManagerName() {
        return this.cacheManagerName;
    }

    public String getCacheConfigurationLocation() {
        return this.cacheConfigurationLocation;
    }

    public List<String> getBundleIncludes() {
        return this.bundleIncludes;
    }

    public List<String> getBundleExcludes() {
        return this.bundleExcludes;
    }

    public Properties getProperties() {
        return this.userProperties;
    }

    public void setProperties(Properties properties) {
        this.userProperties = properties;
    }

    public String get(String key, String defaultValue) {
        return this.userProperties.getProperty(key, defaultValue);
    }

    public boolean isServlet3Enabled() {
        return this.servlet3Enabled;
    }

    public void setServlet3Enabled(boolean servlet3Enabled) {
        this.servlet3Enabled = servlet3Enabled;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    public String readConfig(DandelionConfig config) {
        String retval = null;
        if (System.getProperty(config.getName()) != null) {
            retval = System.getProperty(config.getName());
        }
        if (retval == null && this.filterConfig != null) {
            retval = this.filterConfig.getInitParameter(config.getName());
        }
        if (retval == null && this.userProperties != null) {
            retval = this.userProperties.getProperty(config.getName());
        }
        if (retval == null) {
            retval = this.dandelionMode != null && this.dandelionMode.equals((Object)DandelionMode.PRODUCTION) ? config.getDefaultProdValue() : config.getDefaultDevValue();
        }
        return retval.trim();
    }

    public void setDandelionMode(DandelionMode dandelionMode) {
        this.dandelionMode = dandelionMode;
    }

    public void setMinificationEnabled(boolean minificationEnabled) {
        this.minificationEnabled = minificationEnabled;
    }

    public void setAssetLocationsResolutionStrategy(List<String> assetLocationsResolutionStrategy) {
        this.assetLocationsResolutionStrategy = assetLocationsResolutionStrategy;
    }

    public void setAssetProcessors(List<String> assetProcessors) {
        this.assetProcessors = assetProcessors;
    }

    public void setAssetProcessorEncoding(String assetProcessorEncoding) {
        this.assetProcessorEncoding = assetProcessorEncoding;
    }

    public void setAssetJsExcludes(List<String> assetJsExcludes) {
        this.assetJsExcludes = assetJsExcludes;
    }

    public void setAssetCssExcludes(List<String> assetCssExcludes) {
        this.assetCssExcludes = assetCssExcludes;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setCacheAssetMaxSize(int cacheAssetMaxSize) {
        this.cacheAssetMaxSize = cacheAssetMaxSize;
    }

    public void setCacheRequestMaxSize(int cacheRequestMaxSize) {
        this.cacheRequestMaxSize = cacheRequestMaxSize;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
    }

    public void setCacheConfigurationLocation(String cacheConfigurationLocation) {
        this.cacheConfigurationLocation = cacheConfigurationLocation;
    }

    public void setBundleIncludes(List<String> bundleIncludes) {
        this.bundleIncludes = bundleIncludes;
    }

    public void setBundleExcludes(List<String> bundleExcludes) {
        this.bundleExcludes = bundleExcludes;
    }
}

