/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.bundle.loader.spi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dandelion.core.Context;
import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.bundle.loader.spi.BundleLoader;
import com.github.dandelion.core.storage.BundleStorageUnit;
import com.github.dandelion.core.utils.ResourceScanner;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public abstract class AbstractBundleLoader
implements BundleLoader {
    private ObjectMapper mapper = new ObjectMapper();
    protected Context context;

    @Override
    public void initLoader(Context context) {
        this.context = context;
    }

    @Override
    public List<BundleStorageUnit> loadBundles() {
        this.mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        ArrayList<BundleStorageUnit> bundles = new ArrayList<BundleStorageUnit>();
        Set<String> resourcePaths = null;
        try {
            resourcePaths = ResourceScanner.findResourcePaths(this.getPath(), this.getExcludedPaths(), null, ".json", this.isRecursive());
        }
        catch (IOException e) {
            throw new DandelionException("Something went wrong when scanning files in " + this.getPath(), e);
        }
        this.getLogger().debug("{} resources scanned inside the folder '{}'. Parsing to bundle...", (Object)resourcePaths.size(), (Object)this.getPath());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String resourcePath : resourcePaths) {
            try {
                InputStream configFileStream = classLoader.getResourceAsStream(resourcePath);
                BundleStorageUnit bsu = (BundleStorageUnit)this.mapper.readValue(configFileStream, BundleStorageUnit.class);
                this.getLogger().debug("Parsed {}", (Object)bsu);
                bundles.add(bsu);
            }
            catch (IOException e) {
                StringBuilder sb = new StringBuilder("The file '");
                sb.append(resourcePath);
                sb.append("' is wrongly formatted. Please correct it before continuing.");
                throw new DandelionException(sb.toString(), e);
            }
        }
        return bundles;
    }

    protected abstract Logger getLogger();

    public abstract String getPath();

    public Set<String> getExcludedPaths() {
        return Collections.emptySet();
    }
}

