/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset.processor.support;

import com.github.dandelion.core.utils.PathUtils;
import com.github.dandelion.core.utils.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CssUrlRewriter {
    private static final String URL_SEPARATOR = "/";
    public static String URL_REGEXP = "url\\(\\s*(?!(\"|')?(data|mhtml|cid):)(((\\\\\\))|[^)])*)\\s*\\)";
    public static final Pattern URL_PATTERN = Pattern.compile(URL_REGEXP, 2);
    private static final Pattern URL_SEPARATOR_PATTERN = Pattern.compile("([^/]*)/");
    private static final String ROOT_REPLACE_PATTERN = "../";
    protected String contextPath;

    public void setContextPath(String contextPath) {
        if (StringUtils.isNotBlank(contextPath)) {
            if (contextPath.charAt(0) != '/') {
                contextPath = '/' + contextPath;
            }
            if (contextPath.charAt(contextPath.length() - 1) != '/') {
                contextPath = contextPath + '/';
            }
            this.contextPath = contextPath;
        } else {
            this.contextPath = null;
        }
    }

    public StringBuffer rewriteUrl(String originalCssPath, String newCssPath, String originalCssContent) {
        Matcher matcher = URL_PATTERN.matcher(originalCssContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String url = this.getUrlPath(matcher.group(), originalCssPath, newCssPath);
            matcher.appendReplacement(sb, this.adaptReplacementToMatcher(url));
        }
        matcher.appendTail(sb);
        return sb;
    }

    protected String getUrlPath(String matchedUrl, String originalPath, String newCssPath) {
        int firstSlash;
        String url = matchedUrl.substring(matchedUrl.indexOf(40) + 1, matchedUrl.lastIndexOf(41)).trim();
        String quoteStr = "";
        if (url.startsWith("'") || url.startsWith("\"")) {
            quoteStr = url.charAt(0) + "";
            url = url.substring(1, url.length() - 1);
        }
        if (StringUtils.isNotBlank(this.contextPath) && url.startsWith(this.contextPath)) {
            String rootRelativePath = PathUtils.getRootRelativePath(originalPath);
            url = rootRelativePath + url.substring(this.contextPath.length());
        }
        if (0 == (firstSlash = url.indexOf(47)) || firstSlash != -1 && url.charAt(++firstSlash) == '/') {
            StringBuffer sb = new StringBuffer("url(");
            sb.append(quoteStr).append(url).append(quoteStr).append(")");
            return sb.toString();
        }
        if (url.startsWith(URL_SEPARATOR)) {
            url = url.substring(1, url.length());
        } else if (url.startsWith("./")) {
            url = url.substring(2, url.length());
        }
        String imgUrl = this.getRewrittenImagePath(originalPath, newCssPath, url);
        String finalUrl = "url(" + quoteStr + imgUrl + quoteStr + ")";
        Matcher urlMatcher = URL_PATTERN.matcher(finalUrl);
        if (urlMatcher.find()) {
            finalUrl = PathUtils.normalizePath(finalUrl);
        }
        return finalUrl;
    }

    protected String getRewrittenImagePath(String originalCssPath, String newCssPath, String url) {
        String fullImgPath = PathUtils.concatWebPath(originalCssPath, url);
        String imgUrl = PathUtils.getRelativeWebPath(PathUtils.getParentPath(newCssPath), fullImgPath);
        return imgUrl;
    }

    public String adaptReplacementToMatcher(String replacement) {
        String result = replacement.replaceAll("\\\\", "\\\\\\\\");
        result = result.replaceAll("\\$", "\\\\\\$");
        return result;
    }

    public String getRootRelativePath(String url) {
        Matcher matcher = URL_SEPARATOR_PATTERN.matcher(url);
        StringBuffer result = new StringBuffer();
        boolean first = true;
        while (matcher.find()) {
            if (first) {
                matcher.appendReplacement(result, "");
                first = false;
                continue;
            }
            matcher.appendReplacement(result, ROOT_REPLACE_PATTERN);
        }
        return result.toString();
    }
}

