/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset.processor.impl;

import com.github.dandelion.core.asset.AssetType;
import com.github.dandelion.core.asset.processor.CompatibleAssetType;
import com.github.dandelion.core.asset.processor.ProcessingContext;
import com.github.dandelion.core.asset.processor.spi.AbstractAssetProcessor;
import com.github.dandelion.core.asset.processor.vendor.JSMin;
import com.github.dandelion.core.utils.ReaderInputStream;
import com.github.dandelion.core.utils.WriterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

@CompatibleAssetType(types={AssetType.js})
public class JsMinProcessor
extends AbstractAssetProcessor {
    @Override
    public String getProcessorKey() {
        return "jsmin";
    }

    @Override
    public void doProcess(Reader reader, Writer writer, ProcessingContext processingContext) throws Exception {
        ReaderInputStream is = new ReaderInputStream(reader, processingContext.getContext().getConfiguration().getAssetProcessorEncoding());
        WriterOutputStream os = new WriterOutputStream(writer, processingContext.getContext().getConfiguration().getAssetProcessorEncoding());
        try {
            new JSMin(is, os).jsmin();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ((InputStream)is).close();
            ((OutputStream)os).close();
        }
    }
}

