/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset.processor.impl;

import com.github.dandelion.core.Beta;
import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.asset.Asset;
import com.github.dandelion.core.asset.AssetType;
import com.github.dandelion.core.asset.processor.CompatibleAssetType;
import com.github.dandelion.core.asset.processor.ProcessingContext;
import com.github.dandelion.core.asset.processor.spi.AbstractAssetProcessor;
import com.github.dandelion.core.asset.processor.support.CssUrlRewriter;
import com.github.dandelion.core.utils.StringBuilderUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CompatibleAssetType(types={AssetType.css})
@Beta
public class CssUrlRewritingProcessor
extends AbstractAssetProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssUrlRewritingProcessor.class);
    private CssUrlRewriter urlRewriter = new CssUrlRewriter();

    @Override
    public String getProcessorKey() {
        return "cssurlrewriting";
    }

    @Override
    protected void doProcess(Reader reader, Writer writer, ProcessingContext processingContext) throws Exception {
        Asset asset = processingContext.getAsset();
        String contextPath = processingContext.getRequest().getContextPath();
        LOG.debug("Processing {}", (Object)asset.toLog());
        this.urlRewriter.setContextPath(contextPath);
        StringBuilder assetContent = StringBuilderUtils.toStringBuilder(reader);
        BufferedWriter bufferedWriter = null;
        try {
            LOG.debug("  Old location: {}", (Object)asset.getConfigLocation());
            LOG.debug("  New location: {}", (Object)asset.getFinalLocation());
            bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(this.urlRewriter.rewriteUrl("/" + contextPath + asset.getConfigLocation(), asset.getFinalLocation(), assetContent.toString()).toString());
        }
        catch (IOException e) {
            LOG.error("An error occurred when processing relative paths inside the asset " + asset.toLog());
            throw DandelionException.wrap(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOG.error("An error occurred when processing relative paths inside the asset " + asset.toLog());
                throw DandelionException.wrap(e);
            }
            bufferedWriter.close();
        }
    }
}

