/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset.processor;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.asset.Asset;
import com.github.dandelion.core.asset.AssetType;
import com.github.dandelion.core.asset.processor.CompatibleAssetType;
import com.github.dandelion.core.asset.processor.ProcessingContext;
import com.github.dandelion.core.asset.processor.spi.AssetProcessor;
import com.github.dandelion.core.utils.UrlUtils;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AssetProcessorManager {
    private static final Logger LOG = LoggerFactory.getLogger(AssetProcessorManager.class);
    private Context context;

    public AssetProcessorManager(Context context) {
        this.context = context;
    }

    public Set<Asset> process(Set<Asset> assets, HttpServletRequest request) {
        if (!this.context.getActiveProcessors().isEmpty()) {
            LOG.debug("Processing assets with the following processors: {}", this.context.getActiveProcessors());
            for (Asset asset : assets) {
                ProcessingContext processingContext = new ProcessingContext(this.context, asset, request);
                if (!this.anyProcessorCanBeAppliedFor(asset)) continue;
                String content = this.context.getCacheManager().getContent(asset.getCacheKey());
                StringReader assetReader = new StringReader(content);
                StringWriter assetWriter = new StringWriter();
                List<AssetProcessor> compatibleAssetProcessors = this.getCompatibleProcessorFor(asset);
                for (AssetProcessor assetProcessor : compatibleAssetProcessors) {
                    LOG.trace("Applying processor {} on {}", (Object)assetProcessor.getProcessorKey(), (Object)asset.toLog());
                    assetWriter = new StringWriter();
                    assetProcessor.process(assetReader, assetWriter, processingContext);
                    assetReader = new StringReader(((Object)assetWriter).toString());
                }
                this.context.getCacheManager().remove(asset.getCacheKey());
                String contextTmp = UrlUtils.getCurrentUrl(request, true).toString();
                contextTmp = contextTmp.replaceAll("\\?", "_").replaceAll("&", "_");
                String newCacheKey = this.context.getCacheManager().generateCacheKeyMin(contextTmp, asset);
                asset.setCacheKey(newCacheKey);
                asset.setFinalLocation(UrlUtils.getProcessedUrl("/dandelion-assets/" + newCacheKey, request, null));
                this.context.getCacheManager().storeContent(newCacheKey, ((Object)assetWriter).toString());
            }
        }
        return assets;
    }

    private List<AssetProcessor> getCompatibleProcessorFor(Asset asset) {
        ArrayList<AssetProcessor> compatibleProcessors = new ArrayList<AssetProcessor>();
        for (AssetProcessor assetProcessor : this.context.getActiveProcessors()) {
            CompatibleAssetType annotation = assetProcessor.getClass().getAnnotation(CompatibleAssetType.class);
            CompatibleAssetType compatibleAssetType = annotation;
            List<AssetType> compatibleAssetTypes = Arrays.asList(compatibleAssetType.types());
            if (!compatibleAssetTypes.contains((Object)asset.getType())) continue;
            compatibleProcessors.add(assetProcessor);
        }
        return compatibleProcessors;
    }

    public boolean anyProcessorCanBeAppliedFor(Asset asset) {
        for (AssetProcessor assetProcessor : this.context.getActiveProcessors()) {
            CompatibleAssetType annotation = assetProcessor.getClass().getAnnotation(CompatibleAssetType.class);
            CompatibleAssetType compatibleAssetType = annotation;
            List<AssetType> compatibleAssetTypes = Arrays.asList(compatibleAssetType.types());
            if (!compatibleAssetTypes.contains((Object)asset.getType())) continue;
            return true;
        }
        return false;
    }

    public static void clear() {
    }
}

