/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset.locator.spi;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.asset.Asset;
import com.github.dandelion.core.asset.locator.spi.AssetLocator;
import com.github.dandelion.core.storage.AssetStorageUnit;
import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.core.web.AssetRequestContext;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractAssetLocator
implements AssetLocator {
    protected boolean active = true;
    protected Context context;

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isCachingForced() {
        return false;
    }

    @Override
    public void initLocator(Context context) {
        this.context = context;
    }

    @Override
    public String getLocation(AssetStorageUnit asu, HttpServletRequest request) {
        String location = asu.getLocations().get(this.getLocationKey());
        if (StringUtils.isBlank(location)) {
            StringBuilder sb = new StringBuilder("The asset ");
            sb.append(asu.toLog());
            sb.append(" configured with a '");
            sb.append(this.getLocationKey());
            sb.append("' location key has a blank location. Please correct this location in the corresponding JSON file.");
            throw new DandelionException(sb.toString());
        }
        return this.doGetLocation(asu, request);
    }

    public abstract String doGetLocation(AssetStorageUnit var1, HttpServletRequest var2);

    @Override
    public String getContent(AssetStorageUnit asu, HttpServletRequest request) {
        String location = this.getLocation(asu, request);
        Map<String, Object> parameters = AssetRequestContext.get((ServletRequest)request).getParameters(asu.getName());
        String content = this.doGetContent(location, parameters, request);
        if (!parameters.isEmpty()) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                content = content.replace(entry.getKey(), entry.getValue().toString());
            }
        }
        return content;
    }

    @Override
    public String getContent(Asset asset, HttpServletRequest request) {
        Map<String, Object> parameters = AssetRequestContext.get((ServletRequest)request).getParameters(asset.getName());
        String content = this.doGetContent(asset.getFinalLocation(), parameters, request);
        if (!parameters.isEmpty()) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                content = content.replace(entry.getKey(), entry.getValue().toString());
            }
        }
        return content;
    }

    protected abstract String doGetContent(String var1, Map<String, Object> var2, HttpServletRequest var3);
}

