/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset.locator.impl;

import com.github.dandelion.core.asset.locator.Servlet2Compatible;
import com.github.dandelion.core.asset.locator.spi.AbstractAssetLocator;
import com.github.dandelion.core.storage.AssetStorageUnit;
import com.github.dandelion.core.utils.ResourceUtils;
import com.github.dandelion.core.utils.UrlUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class JarServlet2Locator
extends AbstractAssetLocator
implements Servlet2Compatible {
    private static final String LOCATION_PREFIX = "META-INF/resources/";

    @Override
    public String getLocationKey() {
        return "jar";
    }

    @Override
    public boolean isCachingForced() {
        return true;
    }

    @Override
    public String doGetLocation(AssetStorageUnit asu, HttpServletRequest request) {
        String location = asu.getLocations().get(this.getLocationKey());
        return UrlUtils.getProcessedUrl(location, request, null);
    }

    @Override
    protected String doGetContent(String location, Map<String, Object> parameters, HttpServletRequest request) {
        return ResourceUtils.getFileContentFromClasspath(location.startsWith("/") ? LOCATION_PREFIX + location.substring(1) : LOCATION_PREFIX + location, false);
    }
}

