/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset.locator.impl;

import com.github.dandelion.core.asset.locator.Servlet3Compatible;
import com.github.dandelion.core.asset.locator.spi.AbstractAssetLocator;
import com.github.dandelion.core.storage.AssetStorageUnit;
import com.github.dandelion.core.utils.ResourceUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class JarLocator
extends AbstractAssetLocator
implements Servlet3Compatible {
    @Override
    public String getLocationKey() {
        return "jar";
    }

    @Override
    public boolean isCachingForced() {
        return false;
    }

    @Override
    public String doGetLocation(AssetStorageUnit asu, HttpServletRequest request) {
        String location = asu.getLocations().get(this.getLocationKey());
        return request.getContextPath() + "/" + (location.startsWith("/") ? location.substring(1) : location);
    }

    @Override
    protected String doGetContent(String location, Map<String, Object> parameters, HttpServletRequest request) {
        return ResourceUtils.getContentFromUrl(request, location, true);
    }
}

